/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookConsumer;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.MirrorSynchronizedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.RefsChangedWebhookEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

@Extension
public class BitbucketWebhookEndpoint
implements UnprotectedRootAction {
    public static final String BIBUCKET_WEBHOOK_URL = "bitbucket-server-webhook";
    public static final String X_EVENT_KEY = "X-Event-Key";
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = Logger.getLogger(BitbucketWebhookEndpoint.class.getName());
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Inject
    private BitbucketWebhookConsumer webhookConsumer;

    @POST
    public HttpResponse doTrigger(StaplerRequest request, StaplerResponse response) {
        this.validateContentType(request);
        String eventKey = this.getEventKey(request);
        switch (BitbucketWebhookEvent.findByEventId(eventKey)) {
            case DIAGNOSTICS_PING_EVENT: {
                return HttpResponses.ok();
            }
            case REPO_REF_CHANGE: {
                return this.processRefChangedEvent(request);
            }
            case MIRROR_SYNCHRONIZED_EVENT: {
                return this.processMirrorSynchronizedEvent(request);
            }
        }
        response.setStatus(400);
        return hudson.util.HttpResponses.errorJSON((String)("Event is not supported: " + eventKey));
    }

    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        return BIBUCKET_WEBHOOK_URL;
    }

    private String getEventKey(StaplerRequest request) {
        String eventKey = request.getHeader(X_EVENT_KEY);
        if (StringUtils.isEmpty((CharSequence)eventKey)) {
            throw HttpResponses.errorWithoutStack((int)400, (String)"X-Event-Key header not set");
        }
        return eventKey;
    }

    private <T> T parse(StaplerRequest request, Class<T> type) {
        try {
            Object event = this.objectMapper.readValue((InputStream)request.getInputStream(), type);
            LOGGER.fine(String.format("Payload: %s", event));
            return (T)event;
        }
        catch (IOException e) {
            String error = "Failed to parse the body: " + e.getMessage();
            LOGGER.severe(error);
            throw HttpResponses.errorWithoutStack((int)400, (String)error);
        }
    }

    private HttpResponse processMirrorSynchronizedEvent(StaplerRequest request) {
        MirrorSynchronizedWebhookEvent event = this.parse(request, MirrorSynchronizedWebhookEvent.class);
        this.webhookConsumer.process(event);
        return HttpResponses.ok();
    }

    private HttpResponse processRefChangedEvent(StaplerRequest request) {
        RefsChangedWebhookEvent event = this.parse(request, RefsChangedWebhookEvent.class);
        this.webhookConsumer.process(event);
        return HttpResponses.ok();
    }

    private void validateContentType(StaplerRequest request) {
        String contentType = request.getContentType();
        if (contentType != null && !contentType.startsWith(APPLICATION_JSON)) {
            LOGGER.severe(String.format("Invalid content type %s", contentType));
            throw HttpResponses.errorWithoutStack((int)415, (String)("Invalid content type: '" + contentType + "'. Content type should be '" + APPLICATION_JSON + "'"));
        }
    }
}

