/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.status;

import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketRevisionAction;
import com.atlassian.bitbucket.jenkins.internal.status.BuildStatusPoster;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.triggers.SCMTriggerItem;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class LocalSCMListener
extends SCMListener {
    @Inject
    private BuildStatusPoster buildStatusPoster;

    public LocalSCMListener() {
    }

    LocalSCMListener(BuildStatusPoster buildStatusPoster) {
        this.buildStatusPoster = buildStatusPoster;
    }

    public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) {
        if (!(scm instanceof GitSCM) && !(scm instanceof BitbucketSCM)) {
            return;
        }
        if (scm instanceof BitbucketSCM) {
            this.handleBitbucketSCMCheckout(build, (BitbucketSCM)scm, listener);
            return;
        }
        if (this.isWorkflowRun(build)) {
            Job job = build.getParent();
            GitSCM gitScm = (GitSCM)scm;
            ItemGroup<?> parent = this.getJobParent(job);
            if (parent instanceof MultiBranchProject) {
                MultiBranchProject multiBranchProject = (MultiBranchProject)parent;
                multiBranchProject.getSources().stream().map(BranchSource::getSource).filter(BitbucketSCMSource.class::isInstance).map(BitbucketSCMSource.class::cast).filter(bbsSource -> this.filterSource(gitScm, (BitbucketSCMSource)((Object)bbsSource))).findFirst().ifPresent(scmSource -> this.handleCheckout(scmSource.getBitbucketSCMRepository(), gitScm, build, listener));
            } else if (job instanceof SCMTriggerItem) {
                SCMTriggerItem scmItem = (SCMTriggerItem)job;
                scmItem.getSCMs().stream().filter(BitbucketSCM.class::isInstance).map(BitbucketSCM.class::cast).filter(bScm -> {
                    GitSCM bGitScm = bScm.getGitSCM();
                    return bGitScm != null && Objects.equals(bGitScm.getKey(), scm.getKey());
                }).findFirst().ifPresent(bScm -> this.handleCheckout((BitbucketSCM)((Object)bScm), gitScm, build, listener));
            }
        }
    }

    @VisibleForTesting
    ItemGroup<?> getJobParent(Job<?, ?> job) {
        return job.getParent();
    }

    @VisibleForTesting
    boolean isWorkflowRun(Run<?, ?> build) {
        return build instanceof WorkflowRun;
    }

    @VisibleForTesting
    boolean filterSource(GitSCM gitScm, BitbucketSCMSource bbsSource) {
        return gitScm.getUserRemoteConfigs().stream().anyMatch(userRemoteConfig -> Objects.equals(userRemoteConfig.getUrl(), bbsSource.getRemote()));
    }

    private void handleBitbucketSCMCheckout(Run<?, ?> build, BitbucketSCM scm, TaskListener listener) {
        GitSCM gitSCM;
        if (scm.getServerId() != null && (gitSCM = scm.getGitSCM()) != null) {
            this.handleCheckout(scm, gitSCM, build, listener);
        }
    }

    private void handleCheckout(BitbucketSCM bitbucketScm, GitSCM underlyingScm, Run<?, ?> build, TaskListener listener) {
        this.handleCheckout(bitbucketScm.getBitbucketSCMRepository(), underlyingScm, build, listener);
    }

    private void handleCheckout(BitbucketSCMRepository bitbucketSCMRepository, GitSCM underlyingScm, Run<?, ?> build, TaskListener listener) {
        HashMap env = new HashMap();
        underlyingScm.buildEnvironment(build, env);
        String branch = (String)env.get("GIT_BRANCH");
        String refName = branch != null ? underlyingScm.deriveLocalBranchName(branch) : null;
        BitbucketRevisionAction revisionAction = new BitbucketRevisionAction(bitbucketSCMRepository, refName, (String)env.get("GIT_COMMIT"));
        build.addAction((Action)revisionAction);
        this.buildStatusPoster.postBuildStatus(revisionAction, build, listener);
    }
}

