/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketSearchHelper;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.client.exception.NotFoundException;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.credentials.CredentialUtils;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsProvider;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketMirrorHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidation;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchRequest;
import com.cloudbees.plugins.credentials.Credentials;
import hudson.model.Item;
import hudson.util.FormValidation;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class BitbucketScmFormValidationDelegate
implements BitbucketScmFormValidation {
    private final BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
    private final BitbucketPluginConfiguration bitbucketPluginConfiguration;
    private final JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
    private final JenkinsProvider jenkinsProvider;

    @Inject
    public BitbucketScmFormValidationDelegate(BitbucketClientFactoryProvider bitbucketClientFactoryProvider, BitbucketPluginConfiguration bitbucketPluginConfiguration, JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials, JenkinsProvider jenkinsProvider) {
        this.bitbucketClientFactoryProvider = Objects.requireNonNull(bitbucketClientFactoryProvider, "bitbucketClientFactoryProvider");
        this.bitbucketPluginConfiguration = Objects.requireNonNull(bitbucketPluginConfiguration, "bitbucketPluginConfiguration");
        this.jenkinsToBitbucketCredentials = Objects.requireNonNull(jenkinsToBitbucketCredentials, "jenkinsToBitbucketCredentials");
        this.jenkinsProvider = Objects.requireNonNull(jenkinsProvider, "jenkinsProvider");
    }

    @Override
    public FormValidation doCheckCredentialsId(@Nullable Item context, String credentialsId) {
        this.checkPermission(context);
        Optional<Credentials> providedCredentials = CredentialUtils.getCredentials(credentialsId);
        if (!StringUtils.isBlank((CharSequence)credentialsId) && !providedCredentials.isPresent()) {
            return FormValidation.error((String)"No credentials exist for the provided credentialsId");
        }
        return FormValidation.ok();
    }

    @Override
    public FormValidation doCheckSshCredentialsId(@Nullable Item context, String sshCredentialsId) {
        return this.doCheckCredentialsId(context, sshCredentialsId);
    }

    @Override
    public FormValidation doCheckProjectName(@Nullable Item context, String serverId, String credentialsId, String projectName) {
        this.checkPermission(context);
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return FormValidation.error((String)"Project name is required");
        }
        Optional<Credentials> providedCredentials = CredentialUtils.getCredentials(credentialsId);
        if (!StringUtils.isBlank((CharSequence)credentialsId) && !providedCredentials.isPresent()) {
            return FormValidation.ok();
        }
        return this.bitbucketPluginConfiguration.getServerById(serverId).map(serverConf -> {
            try {
                BitbucketClientFactory clientFactory = this.bitbucketClientFactoryProvider.getClient(serverConf.getBaseUrl(), this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)providedCredentials.orElse(null), serverConf.getGlobalCredentialsProvider("Check Project Name")));
                BitbucketProject project = BitbucketSearchHelper.getProjectByNameOrKey(projectName, clientFactory);
                return FormValidation.ok((String)("Using '" + project.getName() + "' at " + project.getSelfLink()));
            }
            catch (NotFoundException e) {
                return FormValidation.error((String)("The project '" + projectName + "' does not exist or you do not have permission to access it."));
            }
            catch (BitbucketClientException e) {
                return FormValidation.error((String)("Something went wrong when trying to contact Bitbucket Server: " + e.getMessage()));
            }
        }).orElse(FormValidation.ok());
    }

    @Override
    public FormValidation doCheckRepositoryName(@Nullable Item context, String serverId, String credentialsId, String projectName, String repositoryName) {
        this.checkPermission(context);
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return FormValidation.ok();
        }
        Optional<Credentials> providedCredentials = CredentialUtils.getCredentials(credentialsId);
        if (!StringUtils.isBlank((CharSequence)credentialsId) && !providedCredentials.isPresent()) {
            return FormValidation.ok();
        }
        if (StringUtils.isEmpty((CharSequence)repositoryName)) {
            return FormValidation.error((String)"Repository name is required");
        }
        return this.bitbucketPluginConfiguration.getServerById(serverId).map(serverConf -> {
            try {
                BitbucketClientFactory clientFactory = this.bitbucketClientFactoryProvider.getClient(serverConf.getBaseUrl(), this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)providedCredentials.orElse(null), serverConf.getGlobalCredentialsProvider("Check Repository Name")));
                BitbucketRepository repository = BitbucketSearchHelper.getRepositoryByNameOrSlug(projectName, repositoryName, clientFactory);
                return FormValidation.ok((String)("Using '" + repository.getName() + "' at " + (StringUtils.isBlank((CharSequence)repository.getSelfLink()) ? serverConf.getBaseUrl() : repository.getSelfLink())));
            }
            catch (NotFoundException e) {
                return FormValidation.error((String)("The repository '" + repositoryName + "' does not exist or you do not have permission to access it."));
            }
            catch (BitbucketClientException e) {
                return FormValidation.error((String)("Something went wrong when trying to contact Bitbucket Server: " + e.getMessage()));
            }
        }).orElse(FormValidation.ok());
    }

    @Override
    public FormValidation doCheckServerId(@Nullable Item context, String serverId) {
        this.checkPermission(context);
        if (this.bitbucketPluginConfiguration.getValidServerList().stream().noneMatch(server -> server.getId().equals(serverId))) {
            return FormValidation.error((String)"Bitbucket instance is required");
        }
        if (this.bitbucketPluginConfiguration.hasAnyInvalidConfiguration()) {
            return FormValidation.warning((String)"Some servers have been incorrectly configured, and are not displayed.");
        }
        return FormValidation.ok();
    }

    @Override
    public FormValidation doTestConnection(@Nullable Item context, String serverId, String credentialsId, String projectName, String repositoryName, String mirrorName) {
        this.checkPermission(context);
        FormValidation serverIdValidation = this.doCheckServerId(context, serverId);
        if (serverIdValidation.kind == FormValidation.Kind.ERROR) {
            return serverIdValidation;
        }
        FormValidation credentialsIdValidation = this.doCheckCredentialsId(context, credentialsId);
        if (credentialsIdValidation.kind == FormValidation.Kind.ERROR) {
            return credentialsIdValidation;
        }
        FormValidation projectNameValidation = this.doCheckProjectName(context, serverId, credentialsId, projectName);
        if (projectNameValidation.kind == FormValidation.Kind.ERROR) {
            return projectNameValidation;
        }
        FormValidation repositoryNameValidation = this.doCheckRepositoryName(context, serverId, credentialsId, projectName, repositoryName);
        if (repositoryNameValidation.kind == FormValidation.Kind.ERROR) {
            return repositoryNameValidation;
        }
        FormValidation mirrorNameValidation = this.doCheckMirrorName(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        if (mirrorNameValidation.kind == FormValidation.Kind.ERROR) {
            return mirrorNameValidation;
        }
        String serverName = this.bitbucketPluginConfiguration.getServerById(serverId).map(BitbucketServerConfiguration::getServerName).orElse("Bitbucket Server");
        return FormValidation.ok((String)String.format("Jenkins successfully connected to %s's %s / %s on %s", serverName, projectName, repositoryName, StringUtils.isBlank((CharSequence)mirrorName) ? "Primary Server" : mirrorName));
    }

    private void checkPermission(@Nullable Item context) {
        if (context != null) {
            context.checkPermission(Item.EXTENDED_READ);
        } else {
            this.jenkinsProvider.get().checkPermission(Jenkins.ADMINISTER);
        }
    }

    private FormValidation doCheckMirrorName(@Nullable Item context, String serverId, String credentialsId, String projectName, String repositoryName, String mirrorName) {
        this.checkPermission(context);
        if (StringUtils.isBlank((CharSequence)serverId) || StringUtils.isBlank((CharSequence)projectName) || StringUtils.isBlank((CharSequence)repositoryName)) {
            return FormValidation.ok();
        }
        Optional<Credentials> providedCredentials = CredentialUtils.getCredentials(credentialsId);
        if (!StringUtils.isBlank((CharSequence)credentialsId) && !providedCredentials.isPresent()) {
            return FormValidation.ok();
        }
        return this.bitbucketPluginConfiguration.getServerById(serverId).flatMap(serverConfiguration -> new BitbucketMirrorHandler(this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials, (client, project, repo) -> BitbucketSearchHelper.getRepositoryByNameOrSlug(project, repo, client)).fetchAsListBox(new MirrorFetchRequest(serverConfiguration.getBaseUrl(), credentialsId, serverConfiguration.getGlobalCredentialsProvider("Bitbucket SCM Fill Mirror list"), projectName, repositoryName, mirrorName)).stream().filter(mirror -> mirrorName.equalsIgnoreCase(mirror.value)).findAny().map(mirror -> FormValidation.ok())).orElse(FormValidation.ok());
    }
}

