/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketExternalLink;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Project;
import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.TransientActionFactory;

@Extension
public class BitbucketLinkActionFactory
extends TransientActionFactory<Project> {
    @Nonnull
    public Collection<? extends Action> createFor(@Nonnull Project target) {
        if (!(target.getScm() instanceof BitbucketSCM)) {
            return Collections.emptySet();
        }
        BitbucketSCM bitbucketSCM = (BitbucketSCM)target.getScm();
        BitbucketSCM.DescriptorImpl descriptor = (BitbucketSCM.DescriptorImpl)bitbucketSCM.getDescriptor();
        Optional<BitbucketServerConfiguration> maybeConfig = descriptor.getConfiguration(bitbucketSCM.getServerId());
        String serverId = Objects.toString(bitbucketSCM.getServerId(), "");
        String credentialsId = Objects.toString(bitbucketSCM.getCredentialsId(), "");
        FormValidation configValid = FormValidation.aggregate(Arrays.asList(maybeConfig.map(BitbucketServerConfiguration::validate).orElse(FormValidation.error((String)"Config not present")), descriptor.doCheckProjectName((Item)target, serverId, credentialsId, bitbucketSCM.getProjectName()), descriptor.doCheckRepositoryName((Item)target, serverId, credentialsId, bitbucketSCM.getProjectName(), bitbucketSCM.getRepositoryName())));
        if (configValid.kind == FormValidation.Kind.ERROR) {
            return Collections.emptySet();
        }
        String url = maybeConfig.get().getBaseUrl() + "/projects/" + bitbucketSCM.getProjectKey() + "/repos/" + bitbucketSCM.getRepositorySlug();
        return Collections.singleton(BitbucketExternalLink.createDashboardLink(url, target));
    }

    public Class<Project> type() {
        return Project.class;
    }
}

