/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketMirroredRepositoryStatus;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BitbucketMirroredRepository {
    private final boolean available;
    private final Map<String, List<BitbucketNamedLink>> links;
    private final String mirrorName;
    private final int repositoryId;
    private final BitbucketMirroredRepositoryStatus status;

    @JsonCreator
    public BitbucketMirroredRepository(@JsonProperty(value="available", required=true) boolean available, @JsonProperty(value="links", required=true) Map<String, List<BitbucketNamedLink>> links, @JsonProperty(value="mirrorName", required=true) String mirrorName, @JsonProperty(value="repositoryId", required=true) int repositoryId, @JsonProperty(value="status", required=true) BitbucketMirroredRepositoryStatus status) {
        this.available = available;
        this.links = Objects.requireNonNull(links, "links");
        this.mirrorName = Objects.requireNonNull(mirrorName, "mirrorName");
        this.repositoryId = Objects.requireNonNull(Integer.valueOf(repositoryId), "repositoryId");
        this.status = Objects.requireNonNull(status, "status");
    }

    public boolean isAvailable() {
        return this.available;
    }

    public List<BitbucketNamedLink> getCloneUrls() {
        List<BitbucketNamedLink> cloneUrls = this.links.get("clone");
        return cloneUrls == null ? Collections.emptyList() : Collections.unmodifiableList(cloneUrls);
    }

    public Map<String, List<BitbucketNamedLink>> getLinks() {
        return this.links;
    }

    public String getMirrorName() {
        return this.mirrorName;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public BitbucketMirroredRepositoryStatus getStatus() {
        return this.status;
    }
}

