/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.atlassian.bitbucket.jenkins.internal.model.BuildState;
import com.atlassian.bitbucket.jenkins.internal.model.TestResults;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BitbucketBuildStatus {
    private final String buildNumber;
    private final String description;
    private final Long duration;
    private final String key;
    private final String name;
    private final String parent;
    private final String ref;
    private final BuildState state;
    private final TestResults testResults;
    private final String url;

    @JsonCreator
    public BitbucketBuildStatus(@JsonProperty(value="buildNumber") String buildNumber, @JsonProperty(value="description") String description, @JsonProperty(value="duration") Long duration, @JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="parent") String parent, @JsonProperty(value="ref") String ref, @JsonProperty(value="state") BuildState state, @JsonProperty(value="testResults") TestResults testResults, @JsonProperty(value="url") String url) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(state, "state");
        Objects.requireNonNull(url, "url");
        this.buildNumber = buildNumber;
        this.description = description;
        this.duration = duration;
        this.key = key;
        this.name = name;
        this.parent = parent;
        this.ref = ref;
        this.state = state;
        this.testResults = testResults;
        this.url = url;
    }

    @JsonProperty(value="buildNumber")
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="duration")
    @Nullable
    public Long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="parent")
    @Nullable
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="ref")
    @Nullable
    public String getRef() {
        return this.ref;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state.toString();
    }

    @JsonProperty(value="testResults")
    @Nullable
    public TestResults getTestResults() {
        return this.testResults;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public static class Builder {
        private String buildNumber;
        private String description;
        private Long duration;
        private String key;
        private String name;
        private String parent;
        private String ref;
        private BuildState state;
        private TestResults testResults;
        private String url;

        public Builder(String key, BuildState state, String url) {
            this.key = key;
            this.state = state;
            this.url = url;
        }

        public BitbucketBuildStatus build() {
            return new BitbucketBuildStatus(this.buildNumber, this.description, this.duration, this.key, this.name, this.parent, this.ref, this.state, this.testResults, this.url);
        }

        public Builder setBuildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder setRef(@Nullable String ref) {
            if (ref != null && !ref.startsWith("refs/")) {
                Logger.getLogger(BitbucketBuildStatus.class.getName()).warning(String.format("Supplied ref '%s' does not start with 'refs/', ignoring", ref));
                return this;
            }
            this.ref = ref;
            return this;
        }

        public Builder setTestResults(@Nullable TestResults testResults) {
            this.testResults = testResults;
            return this;
        }
    }
}

