/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.ServiceProviderConsumerStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.Messages;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.OAuthConsumerCreateAction;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.OAuthConsumerEntry;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.OAuthConsumerUpdateAction;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.servlet.AuthorizeConfirmationConfig;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.token.OAuthTokenConfiguration;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class OAuthGlobalConfiguration
extends ManagementLink
implements Describable<OAuthGlobalConfiguration> {
    public static final String RELATIVE_PATH = "bbs-oauth";
    @Inject
    private ServiceProviderConsumerStore consumerStore;
    @Inject
    private ServiceProviderTokenStore serviceProviderTokenStore;
    @Inject
    private OAuthTokenConfiguration tokenConfiguration;
    @Inject
    private AuthorizeConfirmationConfig.AuthorizeConfirmationConfigDescriptor authorizeConfirmationConfigDescriptor;

    public Collection<OAuthConsumerEntry> getConsumers() {
        return StreamSupport.stream(this.consumerStore.getAll().spliterator(), false).map(OAuthConsumerEntry::getOAuthConsumerForUpdate).collect(Collectors.toList());
    }

    public OAuthConsumerCreateAction getCreate() {
        return new OAuthConsumerCreateAction(this.consumerStore);
    }

    public OAuthConsumerUpdateAction getConsumer(String key) {
        return new OAuthConsumerUpdateAction(key, this.consumerStore, this.serviceProviderTokenStore);
    }

    public Action getTokens() {
        return this.tokenConfiguration;
    }

    public Action getAuthorize(StaplerRequest req) throws Descriptor.FormException {
        return this.authorizeConfirmationConfigDescriptor.createInstance(req);
    }

    public Descriptor<OAuthGlobalConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @CheckForNull
    public String getIconFileName() {
        return "secure.gif";
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.bitbucket_oauth_consumer_admin_menu();
    }

    @CheckForNull
    public String getUrlName() {
        return RELATIVE_PATH;
    }

    public String getDescription() {
        return Messages.bitbucket_oauth_consumer_admin_menu_description();
    }
}

