/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.config;

import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.branch.MultiBranchProject;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class BitbucketPluginConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(BitbucketPluginConfiguration.class.getName());
    private List<BitbucketServerConfiguration> serverList = new ArrayList<BitbucketServerConfiguration>();

    public BitbucketPluginConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        if (json.isEmpty()) {
            this.setServerList(Collections.emptyList());
        }
        Map<String, String> oldBaseUrls = this.serverList.stream().collect(Collectors.toMap(BitbucketServerConfiguration::getId, BitbucketServerConfiguration::getBaseUrl));
        req.bindJSON((Object)this, json);
        FormValidation aggregate = FormValidation.aggregate((Collection)this.serverList.stream().map(BitbucketServerConfiguration::validate).collect(Collectors.toList()));
        if (aggregate.kind == FormValidation.Kind.OK) {
            this.save();
            this.updateJobs(oldBaseUrls);
            return true;
        }
        return false;
    }

    public Optional<BitbucketServerConfiguration> getServerById(@CheckForNull String serverId) {
        if (StringUtils.isBlank((CharSequence)serverId)) {
            return Optional.empty();
        }
        return this.serverList.stream().filter(server -> server.getId().equals(serverId)).findFirst();
    }

    public List<BitbucketServerConfiguration> getServerList() {
        return this.serverList;
    }

    public void setServerList(List<BitbucketServerConfiguration> serverList) {
        this.serverList = Objects.requireNonNull(serverList);
    }

    public List<BitbucketServerConfiguration> getValidServerList() {
        return this.serverList.stream().filter(server -> server.validate().kind != FormValidation.Kind.ERROR).collect(Collectors.toList());
    }

    public boolean hasAnyInvalidConfiguration() {
        return this.serverList.stream().anyMatch(server -> server.validate().kind == FormValidation.Kind.ERROR);
    }

    private void updateJobs(Map<String, String> oldBaseUrls) {
        Set changedServerIds = this.serverList.stream().filter(serverConfig -> !serverConfig.getBaseUrl().equalsIgnoreCase((String)oldBaseUrls.get(serverConfig.getId()))).map(BitbucketServerConfiguration::getId).collect(Collectors.toSet());
        if (!changedServerIds.isEmpty()) {
            try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                Jenkins.get().getAllItems(ParameterizedJobMixIn.ParameterizedJob.class).forEach(job -> {
                    WorkflowJob workflowJob;
                    CpsScmFlowDefinition definition;
                    BitbucketSCM bitbucketSCM;
                    if (job instanceof AbstractProject && ((AbstractProject)job).getScm() instanceof BitbucketSCM) {
                        AbstractProject project = (AbstractProject)job;
                        BitbucketSCM bitbucketSCM2 = (BitbucketSCM)project.getScm();
                        if (changedServerIds.contains(bitbucketSCM2.getServerId())) {
                            try {
                                project.setScm((SCM)new BitbucketSCM(bitbucketSCM2));
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.SEVERE, String.format("Error updating configuration for Job %s.", project.getName()), e);
                            }
                        }
                    } else if (job instanceof WorkflowJob && ((WorkflowJob)job).getDefinition() instanceof CpsScmFlowDefinition && ((CpsScmFlowDefinition)((WorkflowJob)job).getDefinition()).getScm() instanceof BitbucketSCM && changedServerIds.contains((bitbucketSCM = (BitbucketSCM)(definition = (CpsScmFlowDefinition)(workflowJob = (WorkflowJob)job).getDefinition()).getScm()).getServerId())) {
                        workflowJob.setDefinition((FlowDefinition)new CpsScmFlowDefinition((SCM)new BitbucketSCM(bitbucketSCM), definition.getScriptPath()));
                    }
                });
                Jenkins.get().getAllItems(MultiBranchProject.class).forEach(project -> this.processMultiBranchProject((MultiBranchProject)project, changedServerIds));
            }
        }
    }

    private void processMultiBranchProject(MultiBranchProject project, Set<String> changedServerIds) {
        List sources = project.getSources().stream().map(scm -> {
            BitbucketSCMSource src;
            if (scm instanceof BitbucketSCMSource && changedServerIds.contains((src = (BitbucketSCMSource)((Object)((Object)scm))).getServerId())) {
                return new BitbucketSCMSource(src);
            }
            return scm;
        }).collect(Collectors.toList());
        try {
            project.setSourcesList(sources);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, String.format("Error updating configuration for MultiBranchProject %s.", project.getName()), e);
        }
    }
}

