/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketSearchClient;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import javax.annotation.CheckForNull;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

public class BitbucketSearchClientImpl
implements BitbucketSearchClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String projectName;

    BitbucketSearchClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, @CheckForNull String projectName) {
        this.bitbucketRequestExecutor = Objects.requireNonNull(bitbucketRequestExecutor, "bitbucketRequestExecutor");
        this.projectName = StringUtils.stripToEmpty((String)projectName);
    }

    @Override
    public BitbucketPage<BitbucketProject> findProjects() {
        HttpUrl.Builder urlBuilder = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects");
        if (!StringUtils.isBlank((CharSequence)this.projectName)) {
            urlBuilder.addQueryParameter("name", this.projectName);
        }
        HttpUrl url = urlBuilder.build();
        return this.bitbucketRequestExecutor.makeGetRequest(url, new TypeReference<BitbucketPage<BitbucketProject>>(){}).getBody();
    }

    @Override
    public BitbucketPage<BitbucketRepository> findRepositories(String repositoryName) {
        HttpUrl.Builder urlBuilder = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("repos").addQueryParameter("projectname", this.projectName);
        if (!StringUtils.isBlank((CharSequence)repositoryName)) {
            urlBuilder.addQueryParameter("name", repositoryName);
        }
        HttpUrl url = urlBuilder.build();
        return this.bitbucketRequestExecutor.makeGetRequest(url, new TypeReference<BitbucketPage<BitbucketRepository>>(){}).getBody();
    }
}

