/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.HttpRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.client.exception.NoContentException;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.logging.Logger;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BitbucketRequestExecutor {
    private static final String API_VERSION = "1.0";
    private static final Logger log = Logger.getLogger(BitbucketRequestExecutor.class.getName());
    private final HttpUrl bitbucketBaseUrl;
    private final HttpUrl bitbucketCoreRestPathUrl;
    private final BitbucketCredentials credentials;
    private final ObjectMapper objectMapper;
    private final HttpRequestExecutor httpRequestExecutor;

    public BitbucketRequestExecutor(String bitbucketBaseUrl, HttpRequestExecutor httpRequestExecutor, ObjectMapper objectMapper, BitbucketCredentials credentials) {
        this.bitbucketBaseUrl = Objects.requireNonNull(HttpUrl.parse((String)Objects.requireNonNull(bitbucketBaseUrl)));
        this.bitbucketCoreRestPathUrl = this.bitbucketBaseUrl.newBuilder().addPathSegment("rest").addPathSegment("api").addPathSegment(API_VERSION).build();
        this.httpRequestExecutor = httpRequestExecutor;
        this.objectMapper = objectMapper;
        this.credentials = credentials;
    }

    public HttpUrl getBaseUrl() {
        return this.bitbucketBaseUrl;
    }

    public HttpUrl getCoreRestPath() {
        return this.bitbucketCoreRestPathUrl;
    }

    public void makeDeleteRequest(HttpUrl url) {
        this.httpRequestExecutor.executeDelete(url, this.credentials);
    }

    public <T> BitbucketResponse<T> makeGetRequest(HttpUrl url, TypeReference<T> returnType) {
        return this.makeGetRequest(url, (InputStream in) -> this.objectMapper.readValue(in, returnType));
    }

    public <T> BitbucketResponse<T> makeGetRequest(HttpUrl url, Class<T> returnType) {
        return this.makeGetRequest(url, (InputStream in) -> this.objectMapper.readValue(in, returnType));
    }

    public <T, R> BitbucketResponse<R> makePostRequest(HttpUrl url, T requestPayload, Headers headers, Class<R> returnType) {
        ObjectReader<Object> reader = in -> this.objectMapper.readValue(in, returnType);
        return this.httpRequestExecutor.executePost(url, this.credentials, this.marshall(requestPayload), response -> new BitbucketResponse(response.headers().toMultimap(), this.unmarshall(reader, response.body())), headers);
    }

    public <T> void makePostRequest(HttpUrl url, T requestPayload, Headers headers) {
        this.httpRequestExecutor.executePost(url, this.credentials, this.marshall(requestPayload), HttpRequestExecutor.ResponseConsumer.EMPTY_RESPONSE, headers);
    }

    public <T, R> BitbucketResponse<R> makePutRequest(HttpUrl url, T requestPayload, Class<R> returnType) {
        ObjectReader<Object> reader = in -> this.objectMapper.readValue(in, returnType);
        return this.httpRequestExecutor.executePut(url, this.credentials, this.marshall(requestPayload), response -> new BitbucketResponse(response.headers().toMultimap(), this.unmarshall(reader, response.body())));
    }

    private void ensureNonEmptyBody(Response response) {
        if (response.body() == null) {
            log.info("Bitbucket - No content in response");
            throw new NoContentException("Remote side did not send a response body", response.code());
        }
    }

    private <T> BitbucketResponse<T> makeGetRequest(HttpUrl url, ObjectReader<T> reader) {
        return this.httpRequestExecutor.executeGet(url, this.credentials, response -> {
            this.ensureNonEmptyBody(response);
            Object result = this.unmarshall(reader, response.body());
            return new BitbucketResponse(response.headers().toMultimap(), result);
        });
    }

    private <T> String marshall(T requestPayload) {
        Objects.requireNonNull(requestPayload);
        try {
            return this.objectMapper.writeValueAsString(requestPayload);
        }
        catch (JsonProcessingException e) {
            log.info("Programming error while marshalling webhook model." + e.getMessage());
            throw new BitbucketClientException((IOException)((Object)e));
        }
    }

    private <T> T unmarshall(ObjectReader<T> reader, ResponseBody body) {
        Objects.requireNonNull(body);
        try {
            return reader.readObject(body.byteStream());
        }
        catch (IOException e) {
            log.info("Bitbucket - io exception while unmarshalling the body, Reason " + e.getMessage());
            throw new BitbucketClientException(e);
        }
    }

    private static interface ObjectReader<T> {
        public T readObject(InputStream var1) throws IOException;
    }
}

