/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRepositoryClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketWebhookClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketWebhookClientImpl;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

public class BitbucketRepositoryClientImpl
implements BitbucketRepositoryClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String projectKey;
    private final String repositorySlug;

    BitbucketRepositoryClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repositorySlug) {
        this.bitbucketRequestExecutor = Objects.requireNonNull(bitbucketRequestExecutor, "bitbucketRequestExecutor");
        this.projectKey = Objects.requireNonNull(StringUtils.stripToNull((String)projectKey), "projectKey");
        this.repositorySlug = Objects.requireNonNull(StringUtils.stripToNull((String)repositorySlug), "repositorySlug");
    }

    @Override
    public BitbucketRepository getRepository() {
        HttpUrl.Builder urlBuilder = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repositorySlug);
        return this.bitbucketRequestExecutor.makeGetRequest(urlBuilder.build(), BitbucketRepository.class).getBody();
    }

    @Override
    public BitbucketWebhookClient getWebhookClient() {
        return new BitbucketWebhookClientImpl(this.bitbucketRequestExecutor, this.projectKey, this.repositorySlug);
    }
}

