/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketProjectClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRepositoryClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRepositoryClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

public class BitbucketProjectClientImpl
implements BitbucketProjectClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String projectKey;

    BitbucketProjectClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey) {
        this.bitbucketRequestExecutor = Objects.requireNonNull(bitbucketRequestExecutor, "bitbucketRequestExecutor");
        this.projectKey = Objects.requireNonNull(StringUtils.stripToNull((String)projectKey), "projectKey");
    }

    @Override
    public BitbucketProject getProject() {
        HttpUrl.Builder urlBuilder = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(this.projectKey);
        return this.bitbucketRequestExecutor.makeGetRequest(urlBuilder.build(), BitbucketProject.class).getBody();
    }

    @Override
    public BitbucketRepositoryClient getRepositoryClient(String repositorySlug) {
        return new BitbucketRepositoryClientImpl(this.bitbucketRequestExecutor, this.projectKey, repositorySlug);
    }
}

