/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactrepo.connectors.impl;

import io.jenkins.plugins.artifactrepo.ArtifactRepoParamDefinition;
import io.jenkins.plugins.artifactrepo.Messages;
import io.jenkins.plugins.artifactrepo.connectors.Connector;
import io.jenkins.plugins.artifactrepo.helper.HttpHelper;
import io.jenkins.plugins.artifactrepo.model.HttpResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class Artifactory
implements Connector {
    private static final Logger log = Logger.getLogger(Artifactory.class.getName());
    public static final String ID = "artifactory";
    private final ArtifactRepoParamDefinition definition;
    private final HttpClientBuilder httpBuilder;

    public Artifactory(@Nonnull ArtifactRepoParamDefinition definition) {
        this.definition = definition;
        this.httpBuilder = HttpHelper.getBuilder(definition.getCredentialsId(), definition.getProxy(), definition.isIgnoreCertificate());
    }

    @Override
    public Map<String, String> getResults() {
        switch (this.definition.getParamType()) {
            case "version": {
                return this.getVersionResult();
            }
            case "path": {
                return this.getArtifactResult();
            }
            case "repository": 
            case "test": {
                return this.getRepositoryResult();
            }
        }
        log.info(Messages.log_invalidParameter(this.definition.getParamType()));
        return new HashMap<String, String>();
    }

    private Map<String, String> getArtifactResult() {
        HashMap<String, String> result = new HashMap<String, String>();
        HttpResponse response = this.getArtifactsResponse();
        if (response.getRc() != 200) {
            log.warning(Messages.log_failedRequest(response.getRc()));
            return result;
        }
        JSONObject root = new JSONObject(response.getPayload());
        JSONArray array = root.getJSONArray("results");
        for (int i = 0; i < array.length(); ++i) {
            String key = array.getJSONObject(i).getString("uri");
            String value = StringUtils.substringAfterLast((String)key, (String)"/");
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value})) continue;
            result.put(StringUtils.remove((String)key, (String)"api/storage/"), value);
        }
        return result;
    }

    private Map<String, String> getVersionResult() {
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern versionPattern = Pattern.compile(this.definition.getVersionRegex());
        Map<String, String> artifacts = this.getArtifactResult();
        for (Map.Entry<String, String> entry : artifacts.entrySet()) {
            Optional<String> version = this.extractVersion(entry.getKey(), versionPattern);
            version.ifPresent(v -> result.put((String)entry.getKey(), (String)v));
        }
        return result;
    }

    private HttpResponse getArtifactsResponse() {
        String url = this.definition.getServerUrl() + "/api/search/artifact?name=" + this.definition.getArtifactName();
        if (StringUtils.isNotBlank((CharSequence)this.definition.getRepoName())) {
            url = url + "&repos=" + this.definition.getRepoName();
        }
        return HttpHelper.get(url, this.httpBuilder);
    }

    private Optional<String> extractVersion(@Nonnull String path, @Nonnull Pattern pattern) {
        Matcher versionMatcher = pattern.matcher(path);
        if (versionMatcher.matches() && versionMatcher.groupCount() >= 1) {
            return Optional.of(versionMatcher.group(1));
        }
        return Optional.empty();
    }

    private Map<String, String> getRepositoryResult() {
        HashMap<String, String> result = new HashMap<String, String>();
        HttpResponse response = this.getRepositoriesResponse();
        if (response.getRc() != 200) {
            log.warning(Messages.log_failedRequest(response.getRc()));
            return result;
        }
        JSONArray root = new JSONArray(response.getPayload());
        for (int i = 0; i < root.length(); ++i) {
            String value;
            JSONObject repo = root.getJSONObject(i);
            if (!this.isValidRepoType(repo.getString("type")) || !this.isValidFormatType(repo.getString("packageType"))) continue;
            String key = repo.getString("url");
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value = repo.getString("key")})) continue;
            result.put(key, value);
        }
        return result;
    }

    private HttpResponse getRepositoriesResponse() {
        return HttpHelper.get(this.definition.getServerUrl() + "/api/repositories", this.httpBuilder);
    }

    private boolean isValidRepoType(@Nonnull String value) {
        if (this.definition.getRepoType().isLocal() && "LOCAL".equals(value)) {
            return true;
        }
        if (this.definition.getRepoType().isRemote() && "REMOTE".equals(value)) {
            return true;
        }
        return this.definition.getRepoType().isVirtual() && "VIRTUAL".equals(value);
    }

    private boolean isValidFormatType(@Nonnull String value) {
        if (this.definition.getFormatType().isMaven() && "Maven".equals(value)) {
            return true;
        }
        if (this.definition.getFormatType().isNpm() && Arrays.asList("Npm", "Bower").contains(value)) {
            return true;
        }
        if (this.definition.getFormatType().isPypi() && "Pypi".equals(value)) {
            return true;
        }
        if (this.definition.getFormatType().isDocker() && "Docker".equals(value)) {
            return true;
        }
        return this.definition.getFormatType().isOther() && Stream.of("Maven", "Npm", "Bower", "Pypi", "Docker").noneMatch(s -> s.equals(value));
    }
}

