/*
 * Decompiled with CFR 0.152.
 */
package com.bluersw;

import com.bluersw.AgentParameterValue;
import com.bluersw.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AgentParameterDefinition
extends ParameterDefinition
implements Comparable<AgentParameterDefinition> {
    private static final long serialVersionUID = 8844393428160958128L;
    private static final Logger LOGGER = Logger.getLogger(AgentParameterDefinition.class.getName());
    private static final String MASTER_DEFAULT = "master";
    private static final String DESCRIPTION = "Agent Server Parameter.";
    private final UUID uuid = UUID.randomUUID();
    private String defaultValue;

    @DataBoundConstructor
    public AgentParameterDefinition(String name, String defaultValue) {
        super(name, DESCRIPTION);
        this.setDefaultValue(defaultValue);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @DataBoundSetter
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue == null || defaultValue.isEmpty() || StringUtils.isBlank((String)defaultValue) ? MASTER_DEFAULT : defaultValue;
    }

    public String getDivId() {
        return String.format("%s-%s", this.getName().replaceAll("\\W", "_"), this.uuid);
    }

    @CheckForNull
    public ParameterValue createValue(StaplerRequest staplerRequest, JSONObject jsonObject) {
        Object value = jsonObject.get("value");
        StringBuilder strValue = new StringBuilder();
        if (value instanceof String) {
            strValue.append(value);
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            for (int i = 0; i < jsonValues.size(); ++i) {
                strValue.append(jsonValues.getString(i));
                if (i >= jsonValues.size() - 1) continue;
                strValue.append(",");
            }
        }
        if (strValue.length() == 0) {
            strValue.append(this.getDefaultValue());
        }
        return new AgentParameterValue(jsonObject.getString("name"), strValue.toString());
    }

    @CheckForNull
    public ParameterValue createValue(StaplerRequest staplerRequest) {
        String[] value = staplerRequest.getParameterValues(this.getName());
        if (value == null || value.length == 0 || StringUtils.isBlank((String)value[0])) {
            return this.getDefaultParameterValue();
        }
        return new AgentParameterValue(this.getName(), value[0]);
    }

    public ParameterValue createValue(CLICommand command, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            return new AgentParameterValue(this.getName(), value);
        }
        return this.getDefaultParameterValue();
    }

    public ParameterValue getDefaultParameterValue() {
        return new AgentParameterValue(this.getName(), this.getDefaultValue());
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(AgentParameterDefinition o) {
        if (o.uuid.equals(this.uuid)) {
            return 0;
        }
        return -1;
    }

    public List<String> getComputerNames() {
        String defaultName;
        Computer[] computers = Jenkins.get().getComputers();
        ArrayList<String> nameList = new ArrayList<String>();
        for (Computer computer : computers) {
            nameList.add(computer.getDisplayName());
        }
        if (!nameList.contains(MASTER_DEFAULT)) {
            nameList.add(0, MASTER_DEFAULT);
        }
        if (nameList.contains(defaultName = this.getDefaultValue())) {
            nameList.remove(defaultName);
            nameList.add(0, defaultName);
        }
        return nameList;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"agentParameter"})
    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (name.length() == 0) {
                return FormValidation.error((String)Messages.AgentParameterDefinition_DescriptorImpl_errors_missingName());
            }
            return FormValidation.ok();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.AgentParameterDefinition_DescriptorImpl_DisplayName();
        }

        public ParameterDefinition newInstance(@Nullable StaplerRequest req, @NonNull JSONObject formData) {
            String name = formData.getString("name");
            String value = formData.getString("defaultValue");
            return new AgentParameterDefinition(name, value);
        }

        public String doSetDefaultValue(@AncestorInPath Job job, @QueryParameter String name, @QueryParameter String value) {
            ParameterDefinition pd;
            ParametersDefinitionProperty prop = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            if (prop != null && (pd = prop.getParameterDefinition(name)) instanceof AgentParameterDefinition) {
                ((AgentParameterDefinition)pd).setDefaultValue(value);
                return Messages.AgentParameterDefinition_DescriptorImpl_success_updateDefault();
            }
            LOGGER.log(Level.SEVERE, String.format("%s When executing the doSetDefaultValue method, no build parameter named %s was found.", job.getDisplayName(), name));
            return Messages.AgentParameterDefinition_DescriptorImpl_errors_updateDefault();
        }

        public ListBoxModel doFillValueItems(@AncestorInPath Job job, @QueryParameter String name) {
            ParameterDefinition pd;
            ParametersDefinitionProperty prop = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            if (prop != null && (pd = prop.getParameterDefinition(name)) instanceof AgentParameterDefinition) {
                AgentParameterDefinition spd = (AgentParameterDefinition)pd;
                List<String> computerNames = spd.getComputerNames();
                ListBoxModel list = new ListBoxModel(computerNames.size());
                for (String computerName : computerNames) {
                    list.add(computerName, computerName);
                }
                return list;
            }
            LOGGER.log(Level.SEVERE, String.format("%s When executing the doFillValueItems method, no build parameter named %s was found.", job.getDisplayName(), name));
            return new ListBoxModel(0);
        }
    }
}

