/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.config.Config;
import io.jenkins.tools.pluginmanager.config.HashFunction;
import io.jenkins.tools.pluginmanager.config.LogOutput;
import io.jenkins.tools.pluginmanager.impl.AggregatePluginPrerequisitesNotMetException;
import io.jenkins.tools.pluginmanager.impl.CacheManager;
import io.jenkins.tools.pluginmanager.impl.DirectoryCreationException;
import io.jenkins.tools.pluginmanager.impl.DownloadPluginException;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import io.jenkins.tools.pluginmanager.impl.PluginChecksumMismatchException;
import io.jenkins.tools.pluginmanager.impl.PluginDependencyException;
import io.jenkins.tools.pluginmanager.impl.PluginDependencyStrategyException;
import io.jenkins.tools.pluginmanager.impl.PluginException;
import io.jenkins.tools.pluginmanager.impl.PluginNotFoundException;
import io.jenkins.tools.pluginmanager.impl.SecurityWarning;
import io.jenkins.tools.pluginmanager.impl.UnsupportedChecksumException;
import io.jenkins.tools.pluginmanager.impl.UpdateCenterInfoRetrievalException;
import io.jenkins.tools.pluginmanager.impl.VersionCompatibilityException;
import io.jenkins.tools.pluginmanager.impl.WarBundledPluginException;
import io.jenkins.tools.pluginmanager.parsers.PluginOutputConverter;
import io.jenkins.tools.pluginmanager.parsers.StdOutPluginOutputConverter;
import io.jenkins.tools.pluginmanager.parsers.TxtOutputConverter;
import io.jenkins.tools.pluginmanager.parsers.YamlPluginOutputConverter;
import io.jenkins.tools.pluginmanager.util.FileDownloadResponseHandler;
import io.jenkins.tools.pluginmanager.util.ManifestTools;
import io.jenkins.tools.pluginmanager.util.PluginManagerUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.json.JSONArray;
import org.json.JSONObject;

public class PluginManager
implements Closeable {
    private static final VersionNumber LATEST = new VersionNumber("latest");
    private final List<Plugin> failedPlugins;
    private final File pluginDir;
    private String jenkinsUcLatest;
    private HashFunction hashFunction;
    @CheckForNull
    private final VersionNumber jenkinsVersion;
    @CheckForNull
    private final File jenkinsWarFile;
    private Map<String, Plugin> installedPluginVersions;
    private Map<String, Plugin> bundledPluginVersions;
    private Map<String, List<SecurityWarning>> allSecurityWarnings;
    private Map<String, Plugin> allPluginsAndDependencies;
    private Map<String, Plugin> effectivePlugins;
    private List<Plugin> pluginsToBeDownloaded;
    private final Config cfg;
    private JSONObject latestUcJson;
    private JSONObject experimentalUcJson;
    private JSONObject pluginInfoJson;
    private JSONObject latestPlugins;
    private JSONObject experimentalPlugins;
    private final boolean verbose;
    private final boolean useLatestSpecified;
    private final boolean useLatestAll;
    private final String userAgentInformation;
    private final boolean skipFailedPlugins;
    private CloseableHttpClient httpClient;
    private final CacheManager cm;
    private final LogOutput logOutput;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final String MIRROR_FALLBACK_BASE_URL = "https://archives.jenkins.io/";

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="we want the user to be able to specify a path")
    public PluginManager(Config cfg) {
        this.cfg = cfg;
        this.logOutput = cfg.getLogOutput();
        this.pluginDir = cfg.getPluginDir();
        this.jenkinsVersion = cfg.getJenkinsVersion();
        String warArg = cfg.getJenkinsWar();
        this.jenkinsWarFile = warArg != null ? new File(warArg) : null;
        this.failedPlugins = new ArrayList<Plugin>();
        this.installedPluginVersions = new HashMap<String, Plugin>();
        this.bundledPluginVersions = new HashMap<String, Plugin>();
        this.allSecurityWarnings = new HashMap<String, List<SecurityWarning>>();
        this.allPluginsAndDependencies = new HashMap<String, Plugin>();
        this.verbose = cfg.isVerbose();
        this.jenkinsUcLatest = cfg.getJenkinsUc().toString();
        this.useLatestSpecified = cfg.isUseLatestSpecified();
        this.useLatestAll = cfg.isUseLatestAll();
        this.skipFailedPlugins = cfg.isSkipFailedPlugins();
        this.hashFunction = cfg.getHashFunction();
        this.httpClient = null;
        this.userAgentInformation = this.getUserAgentInformation();
        this.cm = new CacheManager(cfg.getCachePath(), cfg.getLogOutput());
    }

    private String getUserAgentInformation() {
        Object userAgentInformation = "JenkinsPluginManager";
        Properties properties = new Properties();
        try (InputStream propertiesStream = this.getClass().getClassLoader().getResourceAsStream("version.properties");){
            properties.load(propertiesStream);
            userAgentInformation = "JenkinsPluginManager/" + properties.getProperty("project.version");
        }
        catch (IOException e) {
            this.logVerbose("Not able to load/detect version.properties file");
        }
        String additionalUserAgentInfo = System.getProperty("http.agent");
        if (additionalUserAgentInfo != null) {
            userAgentInformation = additionalUserAgentInfo + " " + (String)userAgentInformation;
        }
        return userAgentInformation;
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("standard").build();
            this.httpClient = HttpClients.custom().useSystemProperties().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true)).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setUserAgent(this.userAgentInformation).setDefaultRequestConfig(globalConfig).build();
        }
        return this.httpClient;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean downloadUc) {
        if (this.cfg.isCleanPluginDir() && this.pluginDir.exists()) {
            try {
                this.logVerbose("Cleaning up the target plugin directory: " + this.pluginDir);
                File[] toBeDeleted = this.pluginDir.listFiles();
                if (toBeDeleted != null) {
                    for (File deletableFile : toBeDeleted) {
                        FileUtils.forceDelete((File)deletableFile);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to delete: " + this.pluginDir.getAbsolutePath(), e);
            }
        }
        if (this.cfg.doDownload() && !this.pluginDir.exists()) {
            this.createPluginDir(this.cfg.isCleanPluginDir());
        }
        if (this.useLatestSpecified && this.useLatestAll) {
            throw new PluginDependencyStrategyException("Only one plugin dependency version strategy can be selected at a time");
        }
        VersionNumber jenkinsVersion = this.getJenkinsVersion();
        if (downloadUc) {
            this.getUCJson(jenkinsVersion);
        }
        this.getSecurityWarnings();
        this.showAllSecurityWarnings();
        this.bundledPluginVersions = this.bundledPlugins();
        this.installedPluginVersions = this.installedPlugins();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        this.allPluginsAndDependencies = this.findPluginsAndDependencies(this.cfg.getPlugins(), exceptions);
        this.pluginsToBeDownloaded = this.findPluginsToDownload(this.allPluginsAndDependencies);
        this.effectivePlugins = this.findEffectivePlugins(this.pluginsToBeDownloaded);
        this.listPlugins();
        this.showSpecificSecurityWarnings(this.pluginsToBeDownloaded);
        this.checkVersionCompatibility(jenkinsVersion, this.pluginsToBeDownloaded, exceptions);
        if (!exceptions.isEmpty()) {
            throw new AggregatePluginPrerequisitesNotMetException(exceptions);
        }
        if (this.cfg.doDownload()) {
            this.downloadPlugins(this.pluginsToBeDownloaded);
        }
        this.logMessage("Done");
    }

    void createPluginDir(boolean failIfExists) {
        if (this.pluginDir.exists()) {
            if (failIfExists) {
                throw new DirectoryCreationException("The plugin directory already exists: " + this.pluginDir);
            }
            if (!this.pluginDir.isDirectory()) {
                throw new DirectoryCreationException("The plugin directory path is not a directory: " + this.pluginDir);
            }
            return;
        }
        try {
            Files.createDirectories(this.pluginDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new DirectoryCreationException(String.format("Unable to create plugin directory: '%s', supply a directory with -d <your-directory>", this.pluginDir), e);
        }
    }

    public List<Plugin> findPluginsToDownload(Map<String, Plugin> requestedPlugins) {
        ArrayList<Plugin> pluginsToDownload = new ArrayList<Plugin>();
        for (Map.Entry<String, Plugin> requestedPlugin : requestedPlugins.entrySet()) {
            String pluginName = requestedPlugin.getKey();
            Plugin plugin = requestedPlugin.getValue();
            VersionNumber installedVersion = null;
            if (this.installedPluginVersions.containsKey(pluginName)) {
                installedVersion = this.installedPluginVersions.get(pluginName).getVersion();
            } else if (this.bundledPluginVersions.containsKey(pluginName)) {
                installedVersion = this.bundledPluginVersions.get(pluginName).getVersion();
            } else if (this.bundledPluginVersions.containsKey(pluginName) && this.installedPluginVersions.containsKey(pluginName)) {
                VersionNumber versionNumber = installedVersion = this.bundledPluginVersions.get(pluginName).getVersion().isNewerThan(this.installedPluginVersions.get(pluginName).getVersion()) ? this.bundledPluginVersions.get(pluginName).getVersion() : this.installedPluginVersions.get(pluginName).getVersion();
            }
            if (installedVersion == null) {
                this.logVerbose(String.format("Will install new plugin %s %s", pluginName, plugin.getVersion()));
                pluginsToDownload.add(plugin);
                continue;
            }
            if (!installedVersion.isOlderThan(plugin.getVersion())) continue;
            this.logVerbose(String.format("Installed version (%s) of %s is less than minimum required version of %s, bundled plugin will be upgraded", installedVersion, pluginName, plugin.getVersion()));
            pluginsToDownload.add(plugin);
        }
        return pluginsToDownload;
    }

    public Map<String, Plugin> findEffectivePlugins(List<Plugin> pluginsToBeDownloaded) {
        HashMap<String, Plugin> effectivePlugins = new HashMap<String, Plugin>();
        for (Plugin plugin : pluginsToBeDownloaded) {
            effectivePlugins.put(plugin.getName(), plugin);
        }
        this.sortEffectivePlugins(effectivePlugins, this.installedPluginVersions);
        this.sortEffectivePlugins(effectivePlugins, this.bundledPluginVersions);
        return effectivePlugins;
    }

    private void sortEffectivePlugins(Map<String, Plugin> effectivePlugins, Map<String, Plugin> installedPluginVersions) {
        for (Map.Entry<String, Plugin> installedEntry : installedPluginVersions.entrySet()) {
            if (!effectivePlugins.containsKey(installedEntry.getKey())) {
                effectivePlugins.put(installedEntry.getKey(), installedEntry.getValue());
                continue;
            }
            if (!effectivePlugins.get(installedEntry.getKey()).getVersion().isOlderThan(installedEntry.getValue().getVersion())) continue;
            effectivePlugins.replace(installedEntry.getKey(), installedEntry.getValue());
        }
    }

    void listPlugins() {
        if (this.cfg.isShowPluginsToBeDownloaded()) {
            this.logPlugins("\nInstalled plugins:", new ArrayList<Plugin>(this.installedPluginVersions.values()));
            this.logPlugins("Bundled plugins:", new ArrayList<Plugin>(this.bundledPluginVersions.values()));
            this.logPlugins("All requested plugins:", new ArrayList<Plugin>(this.allPluginsAndDependencies.values()));
            this.logPlugins("Plugins that will be downloaded:", this.pluginsToBeDownloaded);
            this.outputPluginList(new ArrayList<Plugin>(this.effectivePlugins.values()), () -> new StdOutPluginOutputConverter("Resulting plugin list:"));
        }
    }

    private void logPlugins(String description, List<Plugin> plugins) {
        this.logMessage(new StdOutPluginOutputConverter(description).convert(plugins));
    }

    public void outputPluginList(@NonNull List<Plugin> plugins, @NonNull Supplier<PluginOutputConverter> stdOutConverter) {
        System.out.println(this.formatPluginsList(plugins, stdOutConverter));
    }

    private String formatPluginsList(@NonNull List<Plugin> plugins, @NonNull Supplier<PluginOutputConverter> stdOutConverter) {
        switch (this.cfg.getOutputFormat()) {
            case YAML: {
                return new YamlPluginOutputConverter().convert(plugins);
            }
            case TXT: {
                return new TxtOutputConverter().convert(plugins);
            }
        }
        return stdOutConverter.get().convert(plugins);
    }

    public Map<String, List<SecurityWarning>> getSecurityWarnings() {
        if (this.latestUcJson == null) {
            this.logMessage("Unable to get update center json");
            return this.allSecurityWarnings;
        }
        if (!this.latestUcJson.has("warnings")) {
            this.logMessage("update center json has no warnings: ignoring");
            return this.allSecurityWarnings;
        }
        JSONArray warnings = this.latestUcJson.getJSONArray("warnings");
        for (int i = 0; i < warnings.length(); ++i) {
            JSONObject warning = warnings.getJSONObject(i);
            String warningType = warning.getString("type");
            if (!warningType.equals("plugin")) continue;
            String warningId = warning.getString("id");
            String warningMessage = warning.getString("message");
            String warningName = warning.getString("name");
            String warningUrl = warning.getString("url");
            SecurityWarning securityWarning = new SecurityWarning(warningId, warningMessage, warningName, warningUrl);
            JSONArray warningVersions = warning.getJSONArray("versions");
            for (int j = 0; j < warningVersions.length(); ++j) {
                JSONObject warningVersion = warningVersions.getJSONObject(j);
                String firstVersion = "";
                if (warningVersion.has("firstVersion")) {
                    firstVersion = warningVersion.getString("firstVersion");
                }
                String lastVersion = "";
                if (warningVersion.has("lastVersion")) {
                    lastVersion = warningVersion.getString("lastVersion");
                }
                String pattern = warningVersion.getString("pattern");
                securityWarning.addSecurityVersion(firstVersion, lastVersion, pattern);
            }
            this.allSecurityWarnings.computeIfAbsent(warningName, k -> new ArrayList()).add(securityWarning);
        }
        return this.allSecurityWarnings;
    }

    public void showAllSecurityWarnings() {
        if (this.cfg.isShowAllWarnings()) {
            this.allSecurityWarnings.values().stream().flatMap(Collection::stream).sorted(Comparator.comparing(SecurityWarning::getName)).map(w -> w.getName() + " - " + w.getMessage()).forEach(this::logMessage);
        }
    }

    public void showSpecificSecurityWarnings(List<Plugin> plugins) {
        if (this.cfg.isShowWarnings()) {
            this.logMessage("\nSecurity warnings:");
            for (Plugin plugin : plugins) {
                if (!this.warningExists(plugin)) continue;
                String pluginName = plugin.getName();
                this.logMessage(plugin.getSecurityWarnings().stream().map(warning -> String.format("%s (%s): %s %s %s", pluginName, plugin.getVersion(), warning.getId(), warning.getMessage(), warning.getUrl())).collect(Collectors.joining("\n")));
            }
        }
    }

    public List<Plugin> getLatestVersionsOfPlugins(List<Plugin> plugins) {
        return plugins.stream().map(plugin -> {
            String pluginVersion = plugin.getVersion().toString();
            if (plugin.getUrl() != null || plugin.getGroupId() != null || pluginVersion.equals("latest")) {
                return plugin;
            }
            if (this.latestPlugins == null) {
                throw new IllegalStateException("List of plugins is not available. Likely Update Center data has not been downloaded yet");
            }
            if (this.isBeta(pluginVersion) && this.experimentalPlugins.has(plugin.getName())) {
                return this.getUpdatedPlugin((Plugin)plugin, this.experimentalPlugins);
            }
            if (this.latestPlugins.has(plugin.getName())) {
                return this.getUpdatedPlugin((Plugin)plugin, this.latestPlugins);
            }
            return plugin;
        }).collect(Collectors.toList());
    }

    private Plugin getUpdatedPlugin(Plugin plugin, JSONObject pluginsFromUpdateCenter) {
        JSONObject pluginInfo = pluginsFromUpdateCenter.getJSONObject(plugin.getName());
        VersionNumber versionNumber = new VersionNumber(pluginInfo.getString("version"));
        if (versionNumber.isOlderThan(plugin.getVersion())) {
            versionNumber = plugin.getVersion();
        }
        return new Plugin(plugin.getName(), versionNumber.toString(), null, null);
    }

    private boolean isBeta(String version) {
        return StringUtils.indexOfAny((CharSequence)version, (CharSequence[])new CharSequence[]{"alpha", "beta"}) != -1;
    }

    public boolean warningExists(Plugin plugin) {
        String pluginName = plugin.getName();
        ArrayList<SecurityWarning> securityWarnings = new ArrayList<SecurityWarning>();
        if (this.allSecurityWarnings.containsKey(pluginName)) {
            for (SecurityWarning securityWarning : this.allSecurityWarnings.get(pluginName)) {
                for (SecurityWarning.SecurityVersion effectedVersion : securityWarning.getSecurityVersions()) {
                    Matcher m = effectedVersion.getPattern().matcher(plugin.getVersion().toString());
                    if (!m.matches()) continue;
                    securityWarnings.add(securityWarning);
                }
            }
        }
        plugin.setSecurityWarnings(securityWarnings);
        return !securityWarnings.isEmpty();
    }

    public void checkVersionCompatibility(VersionNumber jenkinsVersion, List<Plugin> pluginsToBeDownloaded) {
        this.checkVersionCompatibility(jenkinsVersion, pluginsToBeDownloaded, null);
    }

    public void checkVersionCompatibility(VersionNumber jenkinsVersion, List<Plugin> pluginsToBeDownloaded, @CheckForNull List<Exception> exceptions) {
        if (jenkinsVersion != null && !StringUtils.isEmpty((CharSequence)jenkinsVersion.toString())) {
            for (Plugin p : pluginsToBeDownloaded) {
                VersionNumber pluginJenkinsVersion = p.getJenkinsVersion();
                if (pluginJenkinsVersion == null || !pluginJenkinsVersion.isNewerThan(jenkinsVersion)) continue;
                VersionCompatibilityException exception = new VersionCompatibilityException(String.format("%n%s (%s) requires a greater version of Jenkins (%s) than %s", p.getName(), p.getVersion().toString(), pluginJenkinsVersion.toString(), jenkinsVersion.toString()));
                if (exceptions != null) {
                    exceptions.add(exception);
                    continue;
                }
                throw exception;
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public void downloadPlugins(List<Plugin> plugins) {
        File downloadsTmpDir;
        try {
            downloadsTmpDir = Files.createTempDirectory("plugin-installation-manager-downloads", new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new DownloadPluginException("Cannot create a temporary directory for downloads", ex);
        }
        ForkJoinPool ioThreadPool = new ForkJoinPool(64);
        try {
            ((ForkJoinTask)ioThreadPool.submit(() -> plugins.parallelStream().forEach(plugin -> {
                boolean successfulDownload = this.downloadPlugin((Plugin)plugin, this.getPluginArchive(downloadsTmpDir, (Plugin)plugin));
                if (this.skipFailedPlugins) {
                    this.logMessage("SKIP: Unable to download " + plugin.getName());
                } else if (!successfulDownload) {
                    throw new DownloadPluginException("Unable to download " + plugin.getName());
                }
            }))).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DownloadPluginException) {
                throw (DownloadPluginException)e.getCause();
            }
            e.printStackTrace();
        }
        List<Plugin> failedPlugins = this.getFailedPlugins();
        if (!this.skipFailedPlugins && failedPlugins.size() > 0) {
            throw new DownloadPluginException("Some plugin downloads failed: " + failedPlugins.stream().map(Plugin::getName).collect(Collectors.joining(",")) + ". See " + downloadsTmpDir.getAbsolutePath() + " for the temporary download directory");
        }
        HashSet failedPluginNames = new HashSet(failedPlugins.size());
        failedPlugins.forEach(plugin -> failedPluginNames.add(plugin.getName()));
        for (Plugin plugin2 : plugins) {
            String archiveName = plugin2.getArchiveFileName();
            File downloadedPlugin = new File(downloadsTmpDir, archiveName);
            try {
                if (failedPluginNames.contains(plugin2.getName())) {
                    this.logMessage("Will skip the failed plugin download: " + plugin2.getName() + ". See " + downloadedPlugin.getAbsolutePath() + " for the downloaded file");
                }
                File finalPath = new File(this.pluginDir, archiveName);
                File backupPath = new File(this.pluginDir, plugin2.getBackupFileName());
                if (finalPath.isDirectory()) {
                    FileUtils.cleanDirectory((File)finalPath);
                    Files.delete(finalPath.toPath());
                }
                if (finalPath.exists()) {
                    Files.move(finalPath.toPath(), backupPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                Files.move(downloadedPlugin.toPath(), finalPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                if (this.skipFailedPlugins) {
                    this.logMessage("SKIP: Unable to move " + plugin2.getName() + " to the plugin directory");
                    continue;
                }
                throw new DownloadPluginException("Unable to move " + plugin2.getName() + " to the plugin directory", ex);
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private File getPluginArchive(File pluginDir, Plugin plugin) {
        return new File(pluginDir, plugin.getArchiveFileName());
    }

    public Map<String, Plugin> findPluginsAndDependencies(List<Plugin> requestedPlugins) {
        return this.findPluginsAndDependencies(requestedPlugins, null);
    }

    public Map<String, Plugin> findPluginsAndDependencies(List<Plugin> requestedPlugins, @CheckForNull List<Exception> exceptions) {
        HashMap<String, Plugin> topLevelDependencies = new HashMap<String, Plugin>();
        for (Plugin requestedPlugin : requestedPlugins) {
            topLevelDependencies.put(requestedPlugin.getName(), requestedPlugin);
        }
        HashMap<String, Plugin> allPluginDependencies = new HashMap<String, Plugin>(topLevelDependencies);
        for (Plugin requestedPlugin : requestedPlugins) {
            this.calculateChecksum(requestedPlugin);
            Map<String, Plugin> dependencies = this.resolveRecursiveDependencies(requestedPlugin, topLevelDependencies, exceptions);
            for (Plugin dependentPlugin : dependencies.values()) {
                String dependencyName = dependentPlugin.getName();
                VersionNumber dependencyVersion = dependentPlugin.getVersion();
                this.calculateChecksum(requestedPlugin);
                if (!allPluginDependencies.containsKey(dependencyName)) {
                    allPluginDependencies.put(dependencyName, dependentPlugin);
                    continue;
                }
                Plugin existingDependency = (Plugin)allPluginDependencies.get(dependencyName);
                allPluginDependencies.replace(existingDependency.getName(), this.combineDependencies(existingDependency, dependentPlugin));
            }
        }
        return this.removeOptional(allPluginDependencies);
    }

    private Map<String, Plugin> removeOptional(Map<String, Plugin> plugins) {
        HashMap<String, Plugin> filtered = new HashMap<String, Plugin>();
        for (Map.Entry<String, Plugin> entry : plugins.entrySet()) {
            if (entry.getValue().getOptional()) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        return filtered;
    }

    private Plugin combineDependencies(Plugin a, Plugin b) {
        if (!a.getName().equals(b.getName())) {
            throw new IllegalStateException("Can only combine dependencies on the same plugin. Got " + a.getName() + " and " + b.getName());
        }
        boolean resultIsOptional = a.getOptional() && b.getOptional();
        Plugin higherVersion = a;
        if (a.getVersion().isOlderThan(b.getVersion())) {
            higherVersion = b;
        }
        higherVersion.setOptional(resultIsOptional);
        return higherVersion;
    }

    private void calculateChecksum(Plugin requestedPlugin) {
        if (this.latestPlugins.has(requestedPlugin.getName())) {
            JSONObject pluginFromUpdateCenter = this.latestPlugins.getJSONObject(requestedPlugin.getName());
            String versionInUpdateCenter = pluginFromUpdateCenter.getString("version");
            if (versionInUpdateCenter.equals(requestedPlugin.getVersion().toString())) {
                String checksum = pluginFromUpdateCenter.getString(this.getHashFunction().toString());
                this.logVerbose("Setting checksum for: " + requestedPlugin.getName() + " to " + checksum);
                requestedPlugin.setChecksum(checksum);
            } else if (requestedPlugin.getChecksum() == null) {
                this.logVerbose("Couldn't find checksum for " + requestedPlugin.getName() + " at version: " + requestedPlugin.getVersion().toString());
            }
        } else if (requestedPlugin.getChecksum() == null) {
            this.logVerbose("Couldn't find checksum for: " + requestedPlugin.getName());
        }
    }

    public void outputPluginReplacementInfo(Plugin lowerVersion, Plugin higherVersion) {
        this.logVerbose(String.format("Version of %s (%s) required by %s (%s) is lower than the version required (%s) by %s (%s), upgrading required plugin version", lowerVersion.getName(), lowerVersion.getVersion().toString(), lowerVersion.getParent().getName(), lowerVersion.getParent().getVersion().toString(), higherVersion.getVersion().toString(), higherVersion.getParent().getName(), higherVersion.getParent().getVersion().toString()));
    }

    @Deprecated
    public JSONObject getJson(String urlString) {
        URL url = this.stringToUrlQuietly(urlString);
        return this.getJson(url, null);
    }

    private URL stringToUrlQuietly(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new UpdateCenterInfoRetrievalException("Malformed url for update center", e);
        }
        return url;
    }

    public JSONObject getJson(URL url, String cacheKey) {
        JSONObject jsonObject = this.cm.retrieveFromCache(cacheKey);
        if (jsonObject != null) {
            this.logVerbose("Returning cached value for: " + cacheKey);
            return jsonObject;
        }
        this.logVerbose("Cache miss for: " + cacheKey);
        try {
            String response = url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https") ? (String)this.getViaHttpWithResponseHandler(url.toString(), (ResponseHandler)new BasicResponseHandler(), cacheKey, e -> String.format("Unable to retrieve JSON from %s: %s", url, e.getMessage()), 3) : IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            String result = PluginManagerUtils.removePossibleWrapperText(response);
            JSONObject json = new JSONObject(result);
            this.cm.addToCache(cacheKey, json);
            return json;
        }
        catch (IOException e2) {
            throw new UpdateCenterInfoRetrievalException("Error getting update center json", e2);
        }
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="Cannot do anything with a malformed URL")
    public void getUCJson(VersionNumber jenkinsVersion) {
        this.logVerbose("\nRetrieving update center information");
        this.cm.createCache();
        Object cacheSuffix = jenkinsVersion != null ? "-" + jenkinsVersion : "";
        try {
            URIBuilder uriBuilder = new URIBuilder(this.cfg.getJenkinsUc().toURI());
            if (jenkinsVersion != null) {
                uriBuilder.addParameter("version", jenkinsVersion.toString()).build();
            }
            URL url = uriBuilder.build().toURL();
            this.logVerbose("Update center URL: " + url);
            this.latestUcJson = this.getJson(url, "update-center" + (String)cacheSuffix);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.latestPlugins = this.latestUcJson.getJSONObject("plugins");
        this.experimentalUcJson = this.getJson(this.cfg.getJenkinsUcExperimental(), "experimental-update-center" + (String)cacheSuffix);
        this.experimentalPlugins = this.experimentalUcJson.getJSONObject("plugins");
        this.pluginInfoJson = this.getJson(this.cfg.getJenkinsPluginInfo(), "plugin-versions");
    }

    public JSONArray getPluginDependencyJsonArray(Plugin plugin, JSONObject ucJson) {
        JSONObject plugins = ucJson.getJSONObject("plugins");
        if (!plugins.has(plugin.getName())) {
            return null;
        }
        JSONObject pluginInfo = (JSONObject)plugins.get(plugin.getName());
        if (ucJson.equals(this.pluginInfoJson)) {
            if (pluginInfo.has(plugin.getVersion().toString())) {
                JSONObject specificVersionInfo = pluginInfo.getJSONObject(plugin.getVersion().toString());
                String checksum = specificVersionInfo.getString(this.getHashFunction().toString());
                this.logVerbose("Setting checksum for: " + plugin.getName() + " to " + checksum);
                plugin.setChecksum(checksum);
                plugin.setJenkinsVersion(specificVersionInfo.getString("requiredCore"));
                return (JSONArray)specificVersionInfo.get("dependencies");
            }
        } else {
            plugin.setJenkinsVersion(pluginInfo.getString("requiredCore"));
            String version = pluginInfo.getString("version");
            plugin.setVersion(new VersionNumber(version));
            return (JSONArray)pluginInfo.get("dependencies");
        }
        return null;
    }

    public VersionNumber getLatestPluginVersion(Plugin dependendantPlugin, String pluginName) {
        if (this.latestPlugins == null) {
            throw new IllegalStateException("List of plugins is not available. Likely Update Center data has not been downloaded yet");
        }
        if (!this.latestPlugins.has(pluginName)) {
            throw new PluginNotFoundException(dependendantPlugin, String.format("unable to find dependant plugin %s in update center %s", pluginName, this.jenkinsUcLatest));
        }
        JSONObject pluginInfo = (JSONObject)this.latestPlugins.get(pluginName);
        String latestPluginVersion = pluginInfo.getString("version");
        return new VersionNumber(latestPluginVersion);
    }

    public List<Plugin> resolveDependenciesFromManifest(Plugin plugin) {
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        try {
            String[] dependencies;
            String minimumJenkinsVersion;
            String version;
            File tempFile = Files.createTempFile(FilenameUtils.getName((String)plugin.getName()), ".jpi", new FileAttribute[0]).toFile();
            this.logVerbose(String.format("%nResolving dependencies of %s by downloading plugin to temp file %s and parsing MANIFEST.MF", plugin.getName(), tempFile.toString()));
            if (!this.downloadPlugin(plugin, tempFile)) {
                Files.deleteIfExists(tempFile.toPath());
                throw new DownloadPluginException("Unable to resolve dependencies for " + plugin.getName());
            }
            if ((plugin.getVersion().toString().equals("latest") || plugin.getVersion().toString().equals("experimental")) && !StringUtils.isEmpty((CharSequence)(version = this.getAttributeFromManifest(tempFile, "Plugin-Version")))) {
                plugin.setVersion(new VersionNumber(version));
            }
            if ((minimumJenkinsVersion = this.getAttributeFromManifest(tempFile, "Jenkins-Version")) == null) {
                minimumJenkinsVersion = this.getAttributeFromManifest(tempFile, "Hudson-Version");
            }
            if (minimumJenkinsVersion == null) {
                throw new PluginDependencyException(plugin, "does not contain a Jenkins-Version attribute in the MANIFEST.MF");
            }
            plugin.setJenkinsVersion(minimumJenkinsVersion);
            String dependencyString = this.getAttributeFromManifest(tempFile, "Plugin-Dependencies");
            if (StringUtils.isEmpty((CharSequence)dependencyString)) {
                this.logVerbose("\n" + plugin.getName() + " has no dependencies");
                return dependentPlugins;
            }
            for (String dependency : dependencies = dependencyString.split(",")) {
                String[] pluginInfo = dependency.replace(";resolution:=optional", "").split(":");
                String pluginName = pluginInfo[0];
                String pluginVersion = pluginInfo[1];
                Plugin dependentPlugin = new Plugin(pluginName, pluginVersion, null, null);
                dependentPlugin.setOptional(dependency.contains("resolution:=optional"));
                dependentPlugins.add(dependentPlugin);
                dependentPlugin.setParent(plugin);
            }
            this.logVerbose((String)(dependentPlugins.isEmpty() ? String.format("%n%s has no dependencies", plugin.getName()) : String.format("%n%s depends on: %n", plugin.getName()) + dependentPlugins.stream().map(p -> p.getName() + " " + p.getVersion()).collect(Collectors.joining("\n"))));
            Files.delete(tempFile.toPath());
            return dependentPlugins;
        }
        catch (IOException e) {
            this.logMessage(String.format("Unable to resolve dependencies for %s", plugin.getName()));
            this.logOutput.printVerboseStacktrace(e);
            return dependentPlugins;
        }
    }

    public List<Plugin> resolveDependenciesFromJson(Plugin plugin, JSONObject pluginJson) {
        JSONArray dependencies = this.getPluginDependencyJsonArray(plugin, pluginJson);
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        if (dependencies == null) {
            return null;
        }
        for (int i = 0; i < dependencies.length(); ++i) {
            JSONObject dependency = dependencies.getJSONObject(i);
            String pluginName = dependency.getString("name");
            String pluginVersion = dependency.getString("version");
            Plugin dependentPlugin = new Plugin(pluginName, pluginVersion, null, null);
            dependentPlugin.setOptional(dependency.getBoolean("optional"));
            dependentPlugin.setParent(plugin);
            dependentPlugins.add(dependentPlugin);
        }
        this.logVerbose((String)(dependentPlugins.isEmpty() ? String.format("%n%s has no dependencies", plugin.getName()) : String.format("%n%s depends on: %n", plugin.getName()) + dependentPlugins.stream().map(p -> p.getName() + " " + p.getVersion()).collect(Collectors.joining("\n"))));
        return dependentPlugins;
    }

    public List<Plugin> resolveDirectDependencies(Plugin plugin) {
        String version = plugin.getVersion().toString();
        if (!StringUtils.isEmpty((CharSequence)plugin.getUrl()) || !StringUtils.isEmpty((CharSequence)plugin.getGroupId())) {
            List<Plugin> dependentPlugins = this.resolveDependenciesFromManifest(plugin);
            return dependentPlugins;
        }
        List<Plugin> dependentPlugins = version.equals("latest") ? this.resolveDependenciesFromJson(plugin, this.latestUcJson) : (version.equals("experimental") ? this.resolveDependenciesFromJson(plugin, this.experimentalUcJson) : this.resolveDependenciesFromJson(plugin, this.pluginInfoJson));
        if (dependentPlugins == null) {
            return this.resolveDependenciesFromManifest(plugin);
        }
        return dependentPlugins;
    }

    public Map<String, Plugin> resolveRecursiveDependencies(Plugin plugin) {
        return this.resolveRecursiveDependencies(plugin, null, null);
    }

    public Map<String, Plugin> resolveRecursiveDependencies(Plugin plugin, @CheckForNull Map<String, Plugin> topLevelDependencies) {
        return this.resolveRecursiveDependencies(plugin, topLevelDependencies, null);
    }

    /*
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="Cannot do anything with unexpected runtime exceptions except record them in the exceptions list or throw them")
    public Map<String, Plugin> resolveRecursiveDependencies(Plugin plugin, @CheckForNull Map<String, Plugin> topLevelDependencies, @CheckForNull List<Exception> exceptions) {
        queue = new LinkedList<Plugin>();
        recursiveDependencies = new HashMap<String, Plugin>();
        queue.add(plugin);
        recursiveDependencies.put(plugin.getName(), plugin);
        while (queue.size() != 0) {
            dependency = (Plugin)queue.poll();
            try {
                if (!dependency.isDependenciesSpecified()) {
                    dependency.setDependencies(this.resolveDirectDependencies(dependency));
                }
            }
            catch (RuntimeException e) {
                if (!(e instanceof PluginException)) {
                    e = new PluginDependencyException(dependency, String.format("has unresolvable dependencies: %s", new Object[]{e.getMessage()}), e);
                }
                if (exceptions != null) {
                    exceptions.add(e);
                    continue;
                }
                throw e;
            }
            for (Plugin p : dependency.getDependencies()) {
                dependencyName = p.getName();
                v0 = pinnedPlugin = topLevelDependencies != null ? topLevelDependencies.get(dependencyName) : null;
                if (pinnedPlugin == null) ** GOTO lbl35
                if (!pinnedPlugin.getVersion().isOlderThan(p.getVersion()) || pinnedPlugin.getVersion().equals((Object)PluginManager.LATEST)) ** GOTO lbl33
                message = String.format("depends on %s:%s, but there is an older version defined on the top level - %s:%s", new Object[]{p.getName(), p.getVersion(), pinnedPlugin.getName(), pinnedPlugin.getVersion()});
                exception = new PluginDependencyException(dependency, message);
                if (exceptions != null) {
                    exceptions.add(exception);
                } else {
                    throw exception;
lbl33:
                    // 1 sources

                    this.logVerbose(String.format("Skipping dependency %s:%s and its sub-dependencies, because there is a higher version defined on the top level - %s:%s", new Object[]{p.getName(), p.getVersion(), pinnedPlugin.getName(), pinnedPlugin.getVersion()}));
                    continue;
lbl35:
                    // 1 sources

                    if (this.useLatestSpecified && dependency.isLatest() || this.useLatestAll) {
                        try {
                            latestPluginVersion = this.getLatestPluginVersion(dependency, p.getName());
                            p.setVersion(latestPluginVersion);
                            p.setLatest(true);
                        }
                        catch (PluginNotFoundException e) {
                            if (!p.getOptional()) {
                                throw e;
                            }
                            this.logVerbose(String.format("%s unable to find optional plugin %s in update center %s. Ignoring until it becomes required.", new Object[]{e.getOriginatorPluginAndDependencyChain(), dependencyName, this.jenkinsUcLatest}));
                        }
                    }
                }
                if (!recursiveDependencies.containsKey(dependencyName)) {
                    recursiveDependencies.put(dependencyName, p);
                    if (p.getOptional()) continue;
                    queue.add(p);
                    continue;
                }
                existingDependency = (Plugin)recursiveDependencies.get(dependencyName);
                newDependency = this.combineDependencies(existingDependency, p);
                if (newDependency.equals(existingDependency)) continue;
                this.outputPluginReplacementInfo(existingDependency, newDependency);
                recursiveDependencies.replace(dependencyName, existingDependency, newDependency);
                queue.add(newDependency);
            }
        }
        return recursiveDependencies;
    }

    public boolean downloadPlugin(Plugin plugin, @CheckForNull File location) {
        String pluginName = plugin.getName();
        VersionNumber pluginVersion = plugin.getVersion();
        if (location == null && this.installedPluginVersions.containsKey(pluginName) && this.installedPluginVersions.get(pluginName).getVersion().isNewerThanOrEqualTo(pluginVersion)) {
            this.logVerbose(pluginName + " already installed, skipping");
            return true;
        }
        String pluginDownloadUrl = this.getPluginDownloadUrl(plugin);
        boolean successfulDownload = this.downloadToFile(pluginDownloadUrl, plugin, location);
        if (successfulDownload && location == null) {
            this.logMessage(String.format("%s downloaded successfully", plugin.getName()));
            this.installedPluginVersions.put(plugin.getName(), plugin);
        }
        return successfulDownload;
    }

    public String getPluginDownloadUrl(Plugin plugin) {
        String urlString;
        String pluginName = plugin.getName();
        String pluginVersion = plugin.getVersion().toString();
        String pluginUrl = plugin.getUrl();
        if (StringUtils.isEmpty((CharSequence)pluginVersion)) {
            pluginVersion = "latest";
        }
        String jenkinsUcDownload = System.getenv("JENKINS_UC_DOWNLOAD");
        String jenkinsUcDownloadUrl = System.getenv("JENKINS_UC_DOWNLOAD_URL");
        if (StringUtils.isNotEmpty((CharSequence)pluginUrl)) {
            urlString = pluginUrl;
        } else if (pluginVersion.equals("latest") && !StringUtils.isEmpty((CharSequence)this.jenkinsUcLatest)) {
            urlString = PluginManagerUtils.appendPathOntoUrl(PluginManagerUtils.dirName(this.jenkinsUcLatest), "/latest", pluginName + ".hpi");
        } else if (pluginVersion.equals("experimental")) {
            urlString = PluginManagerUtils.appendPathOntoUrl(PluginManagerUtils.dirName(this.cfg.getJenkinsUcExperimental()), "/latest", pluginName + ".hpi");
        } else if (!StringUtils.isEmpty((CharSequence)plugin.getGroupId())) {
            String groupId = plugin.getGroupId();
            groupId = groupId.replace(".", "/");
            String incrementalsVersionPath = String.format("%s/%s/%s-%s.hpi", pluginName, pluginVersion, pluginName, pluginVersion);
            urlString = PluginManagerUtils.appendPathOntoUrl(this.cfg.getJenkinsIncrementalsRepoMirror(), groupId, incrementalsVersionPath);
        } else {
            urlString = StringUtils.isNotEmpty((CharSequence)jenkinsUcDownloadUrl) ? PluginManagerUtils.appendPathOntoUrl(jenkinsUcDownloadUrl, pluginName, pluginVersion, pluginName + ".hpi") : (StringUtils.isNotEmpty((CharSequence)jenkinsUcDownload) ? PluginManagerUtils.appendPathOntoUrl(jenkinsUcDownload, "/plugins", pluginName, pluginVersion, pluginName + ".hpi") : PluginManagerUtils.appendPathOntoUrl(PluginManagerUtils.removePath(this.cfg.getJenkinsUc()), "/download/plugins", pluginName, pluginVersion, pluginName + ".hpi"));
        }
        this.logVerbose(String.format("Will use url: %s to download %s plugin", urlString, plugin.getName()));
        return urlString;
    }

    public boolean downloadToFile(String urlString, Plugin plugin, @CheckForNull File fileLocation) {
        return this.downloadToFile(urlString, plugin, fileLocation, 3);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE", "PATH_TRAVERSAL_IN", "HTTP_PARAMETER_POLLUTION"})
    public boolean downloadToFile(String urlString, Plugin plugin, @CheckForNull File fileLocation, int maxRetries) {
        boolean success;
        block15: {
            File pluginFile;
            if (fileLocation == null) {
                pluginFile = new File(this.pluginDir, plugin.getArchiveFileName());
                this.logMessage("\nDownloading plugin " + plugin.getName() + " from url: " + urlString);
            } else {
                pluginFile = fileLocation;
            }
            success = true;
            if (urlString.startsWith("http://") || urlString.startsWith("https://")) {
                success = this.downloadHttpToFile(urlString, plugin, pluginFile, maxRetries);
                if (!success && !urlString.startsWith(MIRROR_FALLBACK_BASE_URL)) {
                    this.logMessage("Downloading from mirrors failed, falling back to https://archives.jenkins.io/");
                    urlString = PluginManagerUtils.appendPathOntoUrl((Object)MIRROR_FALLBACK_BASE_URL, "/plugins", plugin.getName(), plugin.getVersion(), plugin.getName() + ".hpi");
                    return this.downloadToFile(urlString, plugin, fileLocation, 1);
                }
            } else if (urlString.startsWith("file://")) {
                success = this.copyLocalFile(urlString, plugin, pluginFile);
            }
            if (success) {
                try (JarFile ignored = new JarFile(pluginFile);){
                    this.verifyChecksum(plugin, pluginFile);
                    plugin.setFile(pluginFile);
                    break block15;
                }
                catch (IOException e) {
                    this.failedPlugins.add(plugin);
                    this.logMessage("Downloaded file is not a valid ZIP");
                    this.logOutput.printVerboseStacktrace(e);
                    return false;
                }
                catch (PluginChecksumMismatchException e) {
                    this.failedPlugins.add(plugin);
                    this.logMessage(e.getMessage());
                    return false;
                }
            }
            this.failedPlugins.add(plugin);
        }
        return success;
    }

    protected boolean downloadHttpToFile(String pluginUrl, Plugin plugin, File pluginFile, int maxRetries) {
        try {
            this.getViaHttpWithResponseHandler(pluginUrl, (ResponseHandler)new FileDownloadResponseHandler(pluginFile), plugin.getName(), e -> String.format("Unable to resolve plugin URL %s, or download plugin %s to file: %s", pluginUrl, plugin.getName(), e.getMessage()), maxRetries);
            try (JarFile ignored = new JarFile(pluginFile);){
                plugin.setFile(pluginFile);
                this.logVerbose("Downloaded and validated plugin " + plugin.getName());
            }
            catch (IOException e2) {
                throw new IOException("Downloaded file for " + plugin.getName() + " is not a valid ZIP", e2);
            }
        }
        catch (IOException e3) {
            this.logMessage(e3.getMessage());
            this.logOutput.printVerboseStacktrace(e3);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"HTTP_PARAMETER_POLLUTION"})
    private <T> T getViaHttpWithResponseHandler(String url, ResponseHandler<? extends T> responseHandler, String resourceName, Function<IOException, String> ioExceptionMessageSupplier, int maxRetries) throws IOException {
        HttpClient httpClient = this.getHttpClient();
        HttpClientContext context = HttpClientContext.create();
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        if (credentialsProvider != null) {
            context.setCredentialsProvider(credentialsProvider);
        }
        HttpGet httpGet = new HttpGet(url);
        boolean success = false;
        for (int i = 0; i < maxRetries; ++i) {
            Object object;
            try {
                Object response = httpClient.execute((HttpUriRequest)httpGet, responseHandler, (HttpContext)context);
                success = true;
                object = response;
            }
            catch (IOException e) {
                String message;
                try {
                    message = ioExceptionMessageSupplier.apply(e);
                    if (i >= maxRetries - 1) {
                        throw new IOException(message, e);
                    }
                    this.logMessage(message);
                }
                catch (Throwable throwable) {
                    List locations = context.getRedirectLocations();
                    if (locations != null) {
                        String message2 = String.format("%s %s from %s (attempt %d of %d)", success ? "Downloaded" : "Tried downloading", resourceName, locations.get(locations.size() - 1), i + 1, maxRetries);
                        if (success) {
                            this.logVerbose(message2);
                        } else {
                            this.logMessage(message2);
                        }
                    }
                    throw throwable;
                }
                List locations = context.getRedirectLocations();
                if (locations == null) continue;
                message = String.format("%s %s from %s (attempt %d of %d)", success ? "Downloaded" : "Tried downloading", resourceName, locations.get(locations.size() - 1), i + 1, maxRetries);
                if (success) {
                    this.logVerbose(message);
                    continue;
                }
                this.logMessage(message);
                continue;
            }
            List locations = context.getRedirectLocations();
            if (locations != null) {
                String message = String.format("%s %s from %s (attempt %d of %d)", success ? "Downloaded" : "Tried downloading", resourceName, locations.get(locations.size() - 1), i + 1, maxRetries);
                if (success) {
                    this.logVerbose(message);
                } else {
                    this.logMessage(message);
                }
            }
            return (T)object;
        }
        throw new IllegalStateException("Reached maximum number of retries without triggering IOException");
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    protected boolean copyLocalFile(String pluginUrl, Plugin plugin, File pluginFile) {
        boolean success = false;
        try {
            File originFile = new File(new URI(pluginUrl));
            if (originFile.exists()) {
                Files.copy(originFile.toPath(), pluginFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                success = true;
            } else {
                String message = String.format("Unable to copy plugin URL %s, original file does not exists or is not accessible", originFile.getAbsolutePath());
                this.logMessage(message);
            }
        }
        catch (IOException | URISyntaxException | InvalidPathException e) {
            this.logMessage("ERROR " + e.getClass().toGenericString());
            String message = String.format("Unable to resolve plugin URL %s, or copy plugin %s to file: %s", pluginUrl, plugin.getName(), e.getMessage());
            this.logMessage(message);
            success = false;
        }
        return success;
    }

    private CredentialsProvider getCredentialsProvider() {
        if (this.cfg.getCredentials().isEmpty()) {
            return null;
        }
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        for (io.jenkins.tools.pluginmanager.config.Credentials credentials : this.cfg.getCredentials()) {
            credsProvider.setCredentials(new AuthScope(credentials.getHost(), credentials.getPort()), (Credentials)new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword()));
        }
        return credsProvider;
    }

    void verifyChecksum(Plugin plugin, File pluginFile) {
        byte[] expectedCheckSumDigest;
        String expectedChecksum = plugin.getChecksum();
        if (expectedChecksum == null) {
            this.logVerbose("No checksum found for " + plugin.getName() + " (probably custom built plugin)");
            return;
        }
        byte[] actualChecksumDigest = this.calculateChecksum(pluginFile);
        try {
            expectedCheckSumDigest = Base64.getDecoder().decode(expectedChecksum);
        }
        catch (IllegalArgumentException e) {
            String actual = new String(Base64.getEncoder().encode(actualChecksumDigest), StandardCharsets.UTF_8);
            throw new PluginChecksumMismatchException(plugin, expectedChecksum, actual);
        }
        if (!MessageDigest.isEqual(actualChecksumDigest, expectedCheckSumDigest)) {
            String actual = new String(Base64.getEncoder().encode(actualChecksumDigest), StandardCharsets.UTF_8);
            throw new PluginChecksumMismatchException(plugin, expectedChecksum, actual);
        }
        this.logVerbose("Checksum valid for: " + plugin.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_SHA1"}, justification="CloudBees update center only uses sha1, remove sha1 once this has been updated.")
    private byte[] calculateChecksum(File pluginFile) {
        try (FileInputStream fin = new FileInputStream(pluginFile);){
            HashFunction hashFunction = this.getHashFunction();
            switch (hashFunction) {
                case SHA1: {
                    byte[] byArray = DigestUtils.sha1((InputStream)fin);
                    return byArray;
                }
                case SHA512: {
                    byte[] byArray = DigestUtils.sha512((InputStream)fin);
                    return byArray;
                }
                case SHA256: {
                    byte[] byArray = DigestUtils.sha256((InputStream)fin);
                    return byArray;
                }
            }
            throw new UnsupportedChecksumException(hashFunction.toString() + "is an unsupported hash function.");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @CheckForNull
    public VersionNumber getJenkinsVersion() {
        if (this.jenkinsVersion != null) {
            return this.jenkinsVersion;
        }
        if (this.jenkinsWarFile != null) {
            return this.getJenkinsVersionFromWar();
        }
        this.logMessage("Unable to determine Jenkins version");
        return null;
    }

    @CheckForNull
    public VersionNumber getJenkinsVersionFromWar() {
        if (this.jenkinsWarFile == null) {
            this.logMessage("Unable to get Jenkins version from the WAR file: WAR file path is not defined.");
            return null;
        }
        String version = this.getAttributeFromManifest(this.jenkinsWarFile, "Jenkins-Version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            this.logMessage("Unable to get Jenkins version from the WAR file " + this.jenkinsWarFile.getPath());
            return null;
        }
        this.logVerbose("Jenkins version: " + version);
        return new VersionNumber(version);
    }

    public String getPluginVersion(File file) {
        String version = this.getAttributeFromManifest(file, "Plugin-Version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            this.logMessage("Unable to get plugin version from " + file);
            return "";
        }
        return version;
    }

    @Deprecated
    public String getAttributeFromManifest(File file, String key) {
        return ManifestTools.getAttributeFromManifest(file, key);
    }

    public Map<String, Plugin> installedPlugins() {
        HashMap<String, Plugin> installedPlugins = new HashMap<String, Plugin>();
        WildcardFileFilter fileFilter = new WildcardFileFilter("*.jpi");
        File[] files = this.pluginDir.listFiles((FileFilter)fileFilter);
        if (files != null) {
            for (File file : files) {
                String pluginName = FilenameUtils.getBaseName((String)file.getName());
                installedPlugins.put(pluginName, new Plugin(pluginName, this.getPluginVersion(file), null, null));
            }
        }
        return installedPlugins;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE", "PATH_TRAVERSAL_IN"})
    public Map<String, Plugin> bundledPlugins() {
        HashMap<String, Plugin> bundledPlugins;
        block19: {
            bundledPlugins = new HashMap<String, Plugin>();
            if (this.jenkinsWarFile == null) {
                this.logMessage("WAR file is not defined, cannot retrieve the bundled plugins");
                return bundledPlugins;
            }
            if (this.jenkinsWarFile.exists()) {
                URI jenkinsWarUri;
                Path path = Paths.get(this.jenkinsWarFile.toString(), new String[0]);
                try {
                    jenkinsWarUri = new URI("jar:" + path.toUri());
                }
                catch (URISyntaxException e) {
                    throw new WarBundledPluginException("Unable to open war file to extract bundled plugin information", e);
                }
                try (FileSystem warFS = FileSystems.newFileSystem(jenkinsWarUri, Collections.emptyMap());){
                    Path warPath = warFS.getPath("/", new String[0]).getRoot();
                    PathMatcher matcher = warFS.getPathMatcher("regex:.*[^detached-]plugins.*\\.\\w+pi");
                    Stream<Path> walk = Files.walk(warPath, new FileVisitOption[0]);
                    Iterator it = walk.iterator();
                    while (it.hasNext()) {
                        Path fileName;
                        Path file = (Path)it.next();
                        if (!matcher.matches(file) || (fileName = file.getFileName()) == null) continue;
                        InputStream in = Files.newInputStream(file, new OpenOption[0]);
                        Path tempFile = Files.createTempFile("PREFIX", "SUFFIX", new FileAttribute[0]);
                        try (FileOutputStream out = new FileOutputStream(tempFile.toFile());){
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        String pluginVersion = this.getPluginVersion(tempFile.toFile());
                        Files.delete(tempFile);
                        String pluginName = FilenameUtils.getBaseName((String)fileName.toString());
                        bundledPlugins.put(pluginName, new Plugin(pluginName, pluginVersion, null, null));
                    }
                    break block19;
                }
                catch (IOException e) {
                    throw new WarBundledPluginException("Unable to open war file to extract bundled plugin information", e);
                }
            }
            this.logMessage("War not found, installing all plugins: " + this.jenkinsWarFile.toString());
        }
        return bundledPlugins;
    }

    public HashFunction getHashFunction() {
        return this.hashFunction;
    }

    public void setHashFunction(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    public String getJenkinsUCLatest() {
        return this.jenkinsUcLatest;
    }

    public void setJenkinsUCLatest(String updateCenterLatest) {
        this.jenkinsUcLatest = updateCenterLatest;
    }

    public void setInstalledPluginVersions(Map<String, Plugin> installedPlugins) {
        this.installedPluginVersions = installedPlugins;
    }

    public void setBundledPluginVersions(Map<String, Plugin> bundledPlugins) {
        this.bundledPluginVersions = bundledPlugins;
    }

    public void setAllPluginsAndDependencies(Map<String, Plugin> allPluginsAndDependencies) {
        this.allPluginsAndDependencies = allPluginsAndDependencies;
    }

    public void setEffectivePlugins(Map<String, Plugin> effectivePlugins) {
        this.effectivePlugins = effectivePlugins;
    }

    public void setPluginsToBeDownloaded(List<Plugin> pluginsToBeDownloaded) {
        this.pluginsToBeDownloaded = pluginsToBeDownloaded;
    }

    private void logVerbose(String message) {
        this.logOutput.printVerboseMessage(message);
    }

    private void logMessage(String message) {
        this.logOutput.printMessage(message);
    }

    public void setLatestUcJson(JSONObject latestUcJson) {
        this.latestUcJson = latestUcJson;
    }

    public void setLatestUcPlugins(JSONObject latestPlugins) {
        this.latestPlugins = latestPlugins;
    }

    public void setExperimentalUcJson(JSONObject experimentalUcJson) {
        this.experimentalUcJson = experimentalUcJson;
    }

    public void setExperimentalPlugins(JSONObject experimentalPlugins) {
        this.experimentalPlugins = experimentalPlugins;
    }

    public void setAllSecurityWarnings(Map<String, List<SecurityWarning>> securityWarnings) {
        this.allSecurityWarnings = securityWarnings;
    }

    public void setPluginInfoJson(JSONObject pluginInfoJson) {
        this.pluginInfoJson = pluginInfoJson;
    }

    public List<Plugin> getFailedPlugins() {
        return this.failedPlugins;
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

