/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import io.jenkins.tools.pluginmanager.impl.Plugin;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class PluginException
extends RuntimeException {
    private final Plugin plugin;

    public PluginException(Plugin plugin, String messageSuffix, Throwable cause) {
        super(messageSuffix, cause);
        this.plugin = plugin;
    }

    public PluginException(Plugin plugin, String messageSuffix) {
        this(plugin, messageSuffix, null);
    }

    public String getOriginatorPluginAndDependencyChain() {
        String chainInfo;
        Plugin currentPlugin;
        ArrayList<Plugin> dependencyChain = new ArrayList<Plugin>();
        dependencyChain.add(currentPlugin);
        int depth = 0;
        for (currentPlugin = this.plugin; currentPlugin.getParent() != null && currentPlugin.getParent() != currentPlugin; currentPlugin = currentPlugin.getParent()) {
            dependencyChain.add(0, currentPlugin);
            if (depth++ <= 20) continue;
            System.err.println("Probably found a dependency cycle in " + this.plugin);
            break;
        }
        if (!(chainInfo = dependencyChain.stream().skip(1L).map(p -> p.getName() + ":" + p.getVersion()).collect(Collectors.joining("->"))).isEmpty()) {
            chainInfo = " (via " + chainInfo + ")";
        }
        Plugin originator = (Plugin)dependencyChain.get(0);
        return String.format("Plugin %s:%s%s ", originator.getName(), originator.getVersion(), chainInfo);
    }

    @Override
    public String getMessage() {
        return this.getOriginatorPluginAndDependencyChain() + super.getMessage();
    }
}

