/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.impl.DownloadPluginException;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;

public class ManifestTools {
    public static Plugin readPluginFromFile(File file) throws IOException {
        Plugin plugin = new Plugin(file.getName(), "undefined", null, null);
        String version = ManifestTools.getAttributeFromManifest(file, "Plugin-Version");
        if (!StringUtils.isEmpty((CharSequence)version)) {
            plugin.setVersion(new VersionNumber(version));
        }
        plugin.setJenkinsVersion(ManifestTools.getAttributeFromManifest(file, "Jenkins-Version"));
        String dependencyString = ManifestTools.getAttributeFromManifest(file, "Plugin-Dependencies");
        if (StringUtils.isEmpty((CharSequence)dependencyString)) {
            return plugin;
        }
        String[] dependencies = dependencyString.split(",");
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        for (String dependency : dependencies) {
            if (dependency.contains("resolution:=optional")) continue;
            String[] pluginInfo = dependency.split(":");
            String pluginName = pluginInfo[0];
            String pluginVersion = pluginInfo[1];
            Plugin dependentPlugin = new Plugin(pluginName, pluginVersion, null, null);
            dependentPlugins.add(dependentPlugin);
            dependentPlugin.setParent(plugin);
        }
        plugin.setDependencies(dependentPlugins);
        return plugin;
    }

    public static Attributes getAttributesFromManifest(File file) throws IOException {
        Manifest mf;
        if (file.isDirectory()) {
            try (FileInputStream istream = new FileInputStream(new File(file, "META-INF/MANIFEST.MF"));){
                mf = new Manifest(istream);
            }
        }
        try (JarFile jarFile = new JarFile(file);){
            mf = jarFile.getManifest();
        }
        return mf.getMainAttributes();
    }

    @CheckForNull
    public static String getAttributeFromManifest(File file, String key) {
        try {
            return ManifestTools.getAttributesFromManifest(file).getValue(key);
        }
        catch (IOException e) {
            System.err.println("Unable to open " + file);
            if (key.equals("Plugin-Dependencies")) {
                throw new DownloadPluginException("Unable to read " + key + " from the manifest of " + file, e);
            }
            return null;
        }
    }
}

