/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.config;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.config.Credentials;
import io.jenkins.tools.pluginmanager.config.HashFunction;
import io.jenkins.tools.pluginmanager.config.LogOutput;
import io.jenkins.tools.pluginmanager.config.OutputFormat;
import io.jenkins.tools.pluginmanager.config.Settings;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Config {
    private final File pluginDir;
    private final boolean cleanPluginDir;
    private final boolean showWarnings;
    private final boolean showAllWarnings;
    private final boolean showAvailableUpdates;
    private final boolean showPluginsToBeDownloaded;
    @CheckForNull
    private final VersionNumber jenkinsVersion;
    @CheckForNull
    private final String jenkinsWar;
    private final List<Plugin> plugins;
    private final boolean verbose;
    private final HashFunction hashFunction;
    private final URL jenkinsUc;
    private final URL jenkinsUcExperimental;
    private final URL jenkinsIncrementalsRepoMirror;
    private final URL jenkinsPluginInfo;
    private final boolean doDownload;
    private final boolean useLatestSpecified;
    private final boolean useLatestAll;
    private final boolean skipFailedPlugins;
    @NonNull
    private final OutputFormat outputFormat;
    private final List<Credentials> credentials;
    private final Path cachePath;
    private final LogOutput logOutput;

    private Config(File pluginDir, boolean cleanPluginDir, boolean showWarnings, boolean showAllWarnings, boolean showAvailableUpdates, boolean showPluginsToBeDownloaded, boolean verbose, VersionNumber jenkinsVersion, String jenkinsWar, List<Plugin> plugins, URL jenkinsUc, URL jenkinsUcExperimental, URL jenkinsIncrementalsRepoMirror, URL jenkinsPluginInfo, boolean doDownload, boolean useLatestSpecified, boolean useLatestAll, boolean skipFailedPlugins, OutputFormat outputFormat, HashFunction hashFunction, List<Credentials> credentials, Path cachePath) {
        this.pluginDir = pluginDir;
        this.cleanPluginDir = cleanPluginDir;
        this.showWarnings = showWarnings;
        this.showAllWarnings = showAllWarnings;
        this.showAvailableUpdates = showAvailableUpdates;
        this.showPluginsToBeDownloaded = showPluginsToBeDownloaded;
        this.verbose = verbose;
        this.jenkinsVersion = jenkinsVersion;
        this.jenkinsWar = jenkinsWar;
        this.plugins = plugins;
        this.jenkinsUc = jenkinsUc;
        this.jenkinsUcExperimental = jenkinsUcExperimental;
        this.jenkinsIncrementalsRepoMirror = jenkinsIncrementalsRepoMirror;
        this.jenkinsPluginInfo = jenkinsPluginInfo;
        this.doDownload = doDownload;
        this.useLatestSpecified = useLatestSpecified;
        this.useLatestAll = useLatestAll;
        this.skipFailedPlugins = skipFailedPlugins;
        this.outputFormat = outputFormat;
        this.credentials = credentials;
        this.hashFunction = hashFunction;
        this.cachePath = cachePath;
        this.logOutput = new LogOutput(verbose);
    }

    public File getPluginDir() {
        return this.pluginDir;
    }

    public boolean isCleanPluginDir() {
        return this.cleanPluginDir;
    }

    public boolean isShowWarnings() {
        return this.showWarnings;
    }

    public boolean isShowAllWarnings() {
        return this.showAllWarnings;
    }

    public boolean isShowAvailableUpdates() {
        return this.showAvailableUpdates;
    }

    public boolean isShowPluginsToBeDownloaded() {
        return this.showPluginsToBeDownloaded;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @CheckForNull
    public String getJenkinsWar() {
        return this.jenkinsWar;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public URL getJenkinsUc() {
        return this.jenkinsUc;
    }

    public URL getJenkinsUcExperimental() {
        return this.jenkinsUcExperimental;
    }

    public URL getJenkinsIncrementalsRepoMirror() {
        return this.jenkinsIncrementalsRepoMirror;
    }

    public URL getJenkinsPluginInfo() {
        return this.jenkinsPluginInfo;
    }

    @CheckForNull
    public VersionNumber getJenkinsVersion() {
        return this.jenkinsVersion;
    }

    public boolean doDownload() {
        return this.doDownload;
    }

    public boolean isUseLatestSpecified() {
        return this.useLatestSpecified;
    }

    public boolean isUseLatestAll() {
        return this.useLatestAll;
    }

    public boolean isSkipFailedPlugins() {
        return this.skipFailedPlugins;
    }

    public List<Credentials> getCredentials() {
        return this.credentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HashFunction getHashFunction() {
        return this.hashFunction;
    }

    @NonNull
    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public Path getCachePath() {
        return this.cachePath;
    }

    public LogOutput getLogOutput() {
        return this.logOutput;
    }

    public static class Builder {
        private File pluginDir;
        private boolean cleanPluginDir;
        private boolean showWarnings;
        private boolean showAllWarnings;
        private boolean showAvailableUpdates;
        private boolean showPluginsToBeDownloaded;
        private boolean verbose;
        private VersionNumber jenkinsVersion;
        private String jenkinsWar;
        private List<Plugin> plugins = new ArrayList<Plugin>();
        private URL jenkinsUc = Settings.DEFAULT_UPDATE_CENTER;
        private URL jenkinsUcExperimental = Settings.DEFAULT_EXPERIMENTAL_UPDATE_CENTER;
        private URL jenkinsIncrementalsRepoMirror = Settings.DEFAULT_INCREMENTALS_REPO_MIRROR;
        private URL jenkinsPluginInfo = Settings.DEFAULT_PLUGIN_INFO;
        private boolean doDownload;
        private boolean useLatestSpecified;
        private boolean useLatestAll;
        private boolean skipFailedPlugins;
        private OutputFormat outputFormat = OutputFormat.STDOUT;
        private List<Credentials> credentials = Collections.emptyList();
        private HashFunction hashFunction = Settings.DEFAULT_HASH_FUNCTION;
        private Path cachePath = Settings.DEFAULT_CACHE_PATH;

        private Builder() {
        }

        public Builder withPluginDir(File pluginDir) {
            this.pluginDir = pluginDir;
            return this;
        }

        public Builder withCleanPluginsDir(boolean cleanPluginDir) {
            this.cleanPluginDir = cleanPluginDir;
            return this;
        }

        public Builder withShowWarnings(boolean showWarnings) {
            this.showWarnings = showWarnings;
            return this;
        }

        public Builder withShowAllWarnings(boolean showAllWarnings) {
            this.showAllWarnings = showAllWarnings;
            return this;
        }

        public Builder withShowAvailableUpdates(boolean showAvailableUpdates) {
            this.showAvailableUpdates = showAvailableUpdates;
            return this;
        }

        public Builder withShowPluginsToBeDownloaded(boolean showPluginsToBeDownloaded) {
            this.showPluginsToBeDownloaded = showPluginsToBeDownloaded;
            return this;
        }

        public Builder withJenkinsVersion(@CheckForNull VersionNumber jenkinsVersion) {
            this.jenkinsVersion = jenkinsVersion;
            return this;
        }

        public Builder withJenkinsWar(@CheckForNull String jenkinsWar) {
            this.jenkinsWar = jenkinsWar;
            return this;
        }

        public Builder withPlugins(List<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        public Builder withIsVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withJenkinsUc(URL jenkinsUc) {
            this.jenkinsUc = jenkinsUc;
            return this;
        }

        public Builder withJenkinsUcExperimental(URL jenkinsUcExperimental) {
            this.jenkinsUcExperimental = jenkinsUcExperimental;
            return this;
        }

        public Builder withJenkinsIncrementalsRepoMirror(URL jenkinsIncrementalsRepoMirror) {
            this.jenkinsIncrementalsRepoMirror = jenkinsIncrementalsRepoMirror;
            return this;
        }

        public Builder withJenkinsPluginInfo(URL jenkinsPluginInfo) {
            this.jenkinsPluginInfo = jenkinsPluginInfo;
            return this;
        }

        public Builder withDoDownload(boolean doDownload) {
            this.doDownload = doDownload;
            return this;
        }

        public Builder withUseLatestSpecified(boolean useLatestSpecifed) {
            this.useLatestSpecified = useLatestSpecifed;
            return this;
        }

        public Builder withUseLatestAll(boolean useLatestAll) {
            this.useLatestAll = useLatestAll;
            return this;
        }

        public Builder withSkipFailedPlugins(boolean skipFailedPlugins) {
            this.skipFailedPlugins = skipFailedPlugins;
            return this;
        }

        public Builder withOutputFormat(OutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public Builder withCredentials(List<Credentials> credentials) {
            if (credentials == null) {
                this.credentials = Collections.emptyList();
                return this;
            }
            this.credentials = credentials;
            return this;
        }

        public Builder withHashFunction(HashFunction hashFunction) {
            this.hashFunction = hashFunction;
            return this;
        }

        public Builder withCachePath(@NonNull Path cachePath) {
            this.cachePath = cachePath;
            return this;
        }

        public Config build() {
            return new Config(this.pluginDir, this.cleanPluginDir, this.showWarnings, this.showAllWarnings, this.showAvailableUpdates, this.showPluginsToBeDownloaded, this.verbose, this.jenkinsVersion, this.jenkinsWar, this.plugins, this.jenkinsUc, this.jenkinsUcExperimental, this.jenkinsIncrementalsRepoMirror, this.jenkinsPluginInfo, this.doDownload, this.useLatestSpecified, this.useLatestAll, this.skipFailedPlugins, this.outputFormat, this.hashFunction, this.credentials, this.cachePath);
        }
    }
}

