/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class URIStringBuilder {
    private String baseUrl;
    private List<String> pathSections = new ArrayList<String>();

    public URIStringBuilder(String uriString) {
        if (uriString == null) {
            uriString = "";
        }
        this.baseUrl = uriString.endsWith("://") ? StringUtils.removeEnd((String)uriString, (String)"/") : StringUtils.stripEnd((String)uriString, (String)"/");
    }

    public URIStringBuilder addPath(String ... pathSectionArray) {
        if (pathSectionArray != null) {
            for (String pathSection : pathSectionArray) {
                this.pathSections.add(StringUtils.strip((String)pathSection, (String)"/"));
            }
        }
        return this;
    }

    public String build() {
        return Stream.concat(Stream.of(this.baseUrl), this.pathSections.stream()).filter(item -> item != null && !item.isEmpty()).collect(Collectors.joining("/"));
    }
}

