/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.tools.pluginmanager.util.URIStringBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public final class PluginManagerUtils {
    private PluginManagerUtils() {
    }

    public static String appendPathOntoUrl(Object urlString, Object ... pathSection) {
        String[] args = new String[pathSection.length];
        for (int i = 0; i < pathSection.length; ++i) {
            Objects.requireNonNull(pathSection[i]);
            args[i] = pathSection[i].toString();
        }
        return PluginManagerUtils.appendPathOntoUrl(urlString.toString(), args);
    }

    public static String appendPathOntoUrl(String urlString, String ... pathSection) {
        return new URIStringBuilder(urlString).addPath(pathSection).build();
    }

    public static String removePossibleWrapperText(String urlText) {
        Pattern pattern;
        Matcher matcher;
        if (urlText != null && urlText.startsWith("updateCenter.post(") && (matcher = (pattern = Pattern.compile("updateCenter.post\\((.*)\\);", 32)).matcher(urlText)).find()) {
            return matcher.group(1);
        }
        return urlText;
    }

    public static String dirName(Object urlString) {
        Objects.requireNonNull(urlString);
        return PluginManagerUtils.dirName(urlString.toString());
    }

    public static String dirName(String urlString) {
        int lastSlashCol = urlString.lastIndexOf(47);
        if (lastSlashCol > 0 && urlString.charAt(lastSlashCol - 1) != '/') {
            return urlString.substring(0, lastSlashCol + 1);
        }
        return urlString;
    }

    public static String removePath(Object urlString) {
        Objects.requireNonNull(urlString);
        return PluginManagerUtils.removePath(urlString.toString());
    }

    public static String removePath(String urlString) {
        String lastUrlString;
        do {
            lastUrlString = urlString;
            if (!(urlString = PluginManagerUtils.dirName(urlString)).endsWith("/")) continue;
            urlString = urlString.substring(0, urlString.length() - 1);
        } while (!urlString.equals(lastUrlString));
        return urlString;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public static File explodePlugin(File source, File destDir) throws IOException {
        try (JarFile jarfile = new JarFile(source);){
            Enumeration<JarEntry> entries = jarfile.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                File file = new File(destDir, je.getName());
                if (!file.exists()) {
                    Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                    file = new File(destDir, je.getName());
                }
                if (je.isDirectory()) continue;
                InputStream is = jarfile.getInputStream(je);
                try (FileOutputStream fo = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)fo);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            File file = destDir;
            return file;
        }
    }
}

