/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Clock;
import java.time.Duration;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CacheManager {
    private Path cache;
    private boolean verbose;
    private Clock clock;

    public CacheManager(Path cache, boolean verbose) {
        this(cache, verbose, Clock.systemDefaultZone());
    }

    CacheManager(Path cache, boolean verbose, Clock clock) {
        this.cache = cache;
        this.verbose = verbose;
        this.clock = clock;
    }

    void createCache() {
        if (!Files.exists(this.cache, new LinkOption[0])) {
            try {
                Path parent = this.cache.getParent();
                if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectory(parent, new FileAttribute[0]);
                }
                Files.createDirectory(this.cache, new FileAttribute[0]);
                if (this.verbose) {
                    System.out.println("Created cache at: " + this.cache);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    void addToCache(String cacheKey, JSONObject value) {
        Path fileToCache = this.cache.resolve(cacheKey + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(fileToCache, StandardCharsets.UTF_8, new OpenOption[0]);){
            value.write((Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    JSONObject retrieveFromCache(String cacheKey) {
        String filename = cacheKey + ".json";
        Path cachedPath = this.cache.resolve(filename);
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(cachedPath, new LinkOption[0]);
            Duration between = Duration.between(lastModifiedTime.toInstant(), this.clock.instant());
            long betweenHours = between.toHours();
            if (betweenHours > 0L) {
                if (this.verbose) {
                    System.out.println("Cache entry expired");
                }
                return null;
            }
            JSONTokener tokener = new JSONTokener(Files.newInputStream(cachedPath, new OpenOption[0]));
            return new JSONObject(tokener);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (RuntimeException e) {
            if (this.verbose) {
                System.err.println("Cache ignored invalid file " + filename + ".");
                e.printStackTrace();
            }
            return null;
        }
        catch (IOException e) {
            if (this.verbose) {
                System.err.println("Cache ignored file " + filename + " because it cannot be read.");
                e.printStackTrace();
            }
            return null;
        }
    }
}

