/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.config;

import io.jenkins.tools.pluginmanager.config.Settings;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class Config {
    private File pluginDir;
    private boolean showWarnings;
    private boolean showAllWarnings;
    private boolean showAvailableUpdates;
    private boolean showPluginsToBeDownloaded;
    private String jenkinsWar;
    private List<Plugin> plugins;
    private boolean verbose;
    private URL jenkinsUc;
    private URL jenkinsUcExperimental;
    private URL jenkinsIncrementalsRepoMirror;
    private URL jenkinsPluginInfo;
    private boolean doDownload;
    private boolean useLatestSpecified;
    private boolean useLatestAll;
    private boolean skipFailedPlugins;

    private Config(File pluginDir, boolean showWarnings, boolean showAllWarnings, boolean showAvailableUpdates, boolean showPluginsToBeDownloaded, boolean verbose, String jenkinsWar, List<Plugin> plugins, URL jenkinsUc, URL jenkinsUcExperimental, URL jenkinsIncrementalsRepoMirror, URL jenkinsPluginInfo, boolean doDownload, boolean useLatestSpecified, boolean useLatestAll, boolean skipFailedPlugins) {
        this.pluginDir = pluginDir;
        this.showWarnings = showWarnings;
        this.showAllWarnings = showAllWarnings;
        this.showAvailableUpdates = showAvailableUpdates;
        this.showPluginsToBeDownloaded = showPluginsToBeDownloaded;
        this.verbose = verbose;
        this.jenkinsWar = jenkinsWar;
        this.plugins = plugins;
        this.jenkinsUc = jenkinsUc;
        this.jenkinsUcExperimental = jenkinsUcExperimental;
        this.jenkinsIncrementalsRepoMirror = jenkinsIncrementalsRepoMirror;
        this.jenkinsPluginInfo = jenkinsPluginInfo;
        this.doDownload = doDownload;
        this.useLatestSpecified = useLatestSpecified;
        this.useLatestAll = useLatestAll;
        this.skipFailedPlugins = skipFailedPlugins;
    }

    public File getPluginDir() {
        return this.pluginDir;
    }

    public boolean isShowWarnings() {
        return this.showWarnings;
    }

    public boolean isShowAllWarnings() {
        return this.showAllWarnings;
    }

    public boolean isShowAvailableUpdates() {
        return this.showAvailableUpdates;
    }

    public boolean isShowPluginsToBeDownloaded() {
        return this.showPluginsToBeDownloaded;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getJenkinsWar() {
        return this.jenkinsWar;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public URL getJenkinsUc() {
        return this.jenkinsUc;
    }

    public URL getJenkinsUcExperimental() {
        return this.jenkinsUcExperimental;
    }

    public URL getJenkinsIncrementalsRepoMirror() {
        return this.jenkinsIncrementalsRepoMirror;
    }

    public URL getJenkinsPluginInfo() {
        return this.jenkinsPluginInfo;
    }

    public boolean doDownload() {
        return this.doDownload;
    }

    public boolean isUseLatestSpecified() {
        return this.useLatestSpecified;
    }

    public boolean isUseLatestAll() {
        return this.useLatestAll;
    }

    public boolean isSkipFailedPlugins() {
        return this.skipFailedPlugins;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File pluginDir;
        private boolean showWarnings;
        private boolean showAllWarnings;
        private boolean showAvailableUpdates;
        private boolean showPluginsToBeDownloaded;
        private boolean verbose;
        private String jenkinsWar;
        private List<Plugin> plugins = new ArrayList<Plugin>();
        private URL jenkinsUc = Settings.DEFAULT_UPDATE_CENTER;
        private URL jenkinsUcExperimental = Settings.DEFAULT_EXPERIMENTAL_UPDATE_CENTER;
        private URL jenkinsIncrementalsRepoMirror = Settings.DEFAULT_INCREMENTALS_REPO_MIRROR;
        private URL jenkinsPluginInfo = Settings.DEFAULT_PLUGIN_INFO;
        private boolean doDownload;
        private boolean useLatestSpecified;
        private boolean useLatestAll;
        private boolean skipFailedPlugins;

        private Builder() {
        }

        public Builder withPluginDir(File pluginDir) {
            this.pluginDir = pluginDir;
            return this;
        }

        public Builder withShowWarnings(boolean showWarnings) {
            this.showWarnings = showWarnings;
            return this;
        }

        public Builder withShowAllWarnings(boolean showAllWarnings) {
            this.showAllWarnings = showAllWarnings;
            return this;
        }

        public Builder withShowAvailableUpdates(boolean showAvailableUpdates) {
            this.showAvailableUpdates = showAvailableUpdates;
            return this;
        }

        public Builder withShowPluginsToBeDownloaded(boolean showPluginsToBeDownloaded) {
            this.showPluginsToBeDownloaded = showPluginsToBeDownloaded;
            return this;
        }

        public Builder withJenkinsWar(String jenkinsWar) {
            this.jenkinsWar = jenkinsWar;
            return this;
        }

        public Builder withPlugins(List<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        public Builder withIsVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withJenkinsUc(URL jenkinsUc) {
            this.jenkinsUc = jenkinsUc;
            return this;
        }

        public Builder withJenkinsUcExperimental(URL jenkinsUcExperimental) {
            this.jenkinsUcExperimental = jenkinsUcExperimental;
            return this;
        }

        public Builder withJenkinsIncrementalsRepoMirror(URL jenkinsIncrementalsRepoMirror) {
            this.jenkinsIncrementalsRepoMirror = jenkinsIncrementalsRepoMirror;
            return this;
        }

        public Builder withJenkinsPluginInfo(URL jenkinsPluginInfo) {
            this.jenkinsPluginInfo = jenkinsPluginInfo;
            return this;
        }

        public Builder withDoDownload(boolean doDownload) {
            this.doDownload = doDownload;
            return this;
        }

        public Builder withUseLatestSpecified(boolean useLatestSpecifed) {
            this.useLatestSpecified = useLatestSpecifed;
            return this;
        }

        public Builder withUseLatestAll(boolean useLatestAll) {
            this.useLatestAll = useLatestAll;
            return this;
        }

        public Builder withSkipFailedPlugins(boolean skipFailedPlugins) {
            this.skipFailedPlugins = skipFailedPlugins;
            return this;
        }

        public Config build() {
            return new Config(this.pluginDir, this.showWarnings, this.showAllWarnings, this.showAvailableUpdates, this.showPluginsToBeDownloaded, this.verbose, this.jenkinsWar, this.plugins, this.jenkinsUc, this.jenkinsUcExperimental, this.jenkinsIncrementalsRepoMirror, this.jenkinsPluginInfo, this.doDownload, this.useLatestSpecified, this.useLatestAll, this.skipFailedPlugins);
        }
    }
}

