/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import hudson.util.VersionNumber;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Plugin {
    private String name;
    private String originalName;
    private VersionNumber version;
    private String groupId;
    private String url;
    private File file;
    private boolean isPluginOptional;
    private List<Plugin> dependencies;
    private List<Plugin> dependents;

    public Plugin(String name, String version, String url, String groupId) {
        this.originalName = name;
        this.name = name;
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "latest";
        }
        this.version = new VersionNumber(version);
        this.url = url;
        this.groupId = groupId;
        this.dependencies = new ArrayList<Plugin>();
        this.dependents = new ArrayList<Plugin>();
    }

    public Plugin(String name, String version, boolean isPluginOptional) {
        this.name = name;
        this.originalName = name;
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "latest";
        }
        this.version = new VersionNumber(version);
        this.isPluginOptional = isPluginOptional;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(VersionNumber version) {
        this.version = version;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setPluginOptional(boolean isPluginOptional) {
        this.isPluginOptional = isPluginOptional;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return this.name;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArchiveFileName() {
        return this.name + ".jpi";
    }

    public boolean getPluginOptional() {
        return this.isPluginOptional;
    }

    public File getFile() {
        return this.file;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setDependencies(List<Plugin> dependencies) {
        this.dependencies = dependencies;
    }

    public List<Plugin> getDependencies() {
        return this.dependencies;
    }

    public void setDependent(Plugin dependent) {
        this.dependents.add(dependent);
    }

    public List<Plugin> getDependents() {
        return this.dependents;
    }

    public String toString() {
        return this.name + " " + this.version + " " + this.url;
    }
}

