/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.pipeline;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.docker.connector.DockerComputerConnector;
import io.jenkins.docker.pipeline.DockerNodeStepExecution;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DockerNodeStep
extends Step {
    private String dockerHost;
    private String credentialsId;
    private String image;
    private String remoteFs;
    private DockerComputerConnector connector;

    @DataBoundConstructor
    public DockerNodeStep(String image) {
        this.image = image;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    @DataBoundSetter
    public void setDockerHost(String dockerHost) {
        this.dockerHost = Util.fixEmpty((String)dockerHost);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public String getImage() {
        return this.image;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    @DataBoundSetter
    public void setRemoteFs(String remoteFs) {
        this.remoteFs = Util.fixEmpty((String)remoteFs);
    }

    public DockerComputerConnector getConnector() {
        return this.connector;
    }

    @DataBoundSetter
    public void setConnector(DockerComputerConnector connector) {
        this.connector = connector;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DockerNodeStepExecution(context, this.connector, this.dockerHost, this.credentialsId, this.image, this.remoteFs);
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "dockerNode";
        }

        @Nonnull
        public String getDisplayName() {
            return "Docker Node (\u26a0\ufe0f Experimental)";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String uri) {
            DockerServerEndpoint.DescriptorImpl descriptor = (DockerServerEndpoint.DescriptorImpl)Jenkins.getInstance().getDescriptor(DockerServerEndpoint.class);
            return descriptor.doFillCredentialsIdItems(item, uri);
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FlowNode.class);
        }

        public Set<? extends Class<?>> getProvidedContext() {
            return ImmutableSet.of(Computer.class, FilePath.class, Node.class, Launcher.class);
        }
    }
}

