/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.utils.PortUtils;
import com.trilead.ssh2.signature.RSAKeyAlgorithm;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.remoting.Base64;
import hudson.slaves.ComputerLauncher;
import hudson.util.ListBoxModel;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.model.Jenkins;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jenkinsci.Symbol;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerComputerSSHConnector
extends DockerComputerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerComputerSSHConnector.class);
    private final SSHKeyStrategy sshKeyStrategy;
    private int port;
    @CheckForNull
    private String jvmOptions;
    @CheckForNull
    private String javaPath;
    @CheckForNull
    private String prefixStartSlaveCmd;
    @CheckForNull
    private String suffixStartSlaveCmd;
    @CheckForNull
    private Integer launchTimeoutSeconds;
    @CheckForNull
    private Integer maxNumRetries;
    @CheckForNull
    private Integer retryWaitTime;

    @DataBoundConstructor
    public DockerComputerSSHConnector(SSHKeyStrategy sshKeyStrategy) {
        this.sshKeyStrategy = sshKeyStrategy;
        this.port = 22;
        this.maxNumRetries = 30;
        this.retryWaitTime = 2;
    }

    public SSHKeyStrategy getSshKeyStrategy() {
        return this.sshKeyStrategy;
    }

    public int getPort() {
        return this.port;
    }

    @DataBoundSetter
    public void setPort(int port) {
        this.port = port;
    }

    @CheckForNull
    public String getJvmOptions() {
        return this.jvmOptions;
    }

    @DataBoundSetter
    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @CheckForNull
    public String getJavaPath() {
        return this.javaPath;
    }

    @DataBoundSetter
    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    @CheckForNull
    public String getPrefixStartSlaveCmd() {
        return this.prefixStartSlaveCmd;
    }

    @DataBoundSetter
    public void setPrefixStartSlaveCmd(String prefixStartSlaveCmd) {
        this.prefixStartSlaveCmd = prefixStartSlaveCmd;
    }

    @CheckForNull
    public String getSuffixStartSlaveCmd() {
        return this.suffixStartSlaveCmd;
    }

    @DataBoundSetter
    public void setSuffixStartSlaveCmd(String suffixStartSlaveCmd) {
        this.suffixStartSlaveCmd = suffixStartSlaveCmd;
    }

    @CheckForNull
    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds;
    }

    @DataBoundSetter
    public void setLaunchTimeoutSeconds(Integer launchTimeoutSeconds) {
        this.launchTimeoutSeconds = launchTimeoutSeconds;
    }

    @CheckForNull
    public Integer getMaxNumRetries() {
        return this.maxNumRetries;
    }

    @DataBoundSetter
    public void setMaxNumRetries(Integer maxNumRetries) {
        this.maxNumRetries = maxNumRetries;
    }

    @CheckForNull
    public Integer getRetryWaitTime() {
        return this.retryWaitTime;
    }

    @DataBoundSetter
    public void setRetryWaitTime(Integer retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
    }

    @Override
    public void beforeContainerCreated(DockerAPI api, String workdir, CreateContainerCmd cmd) throws IOException, InterruptedException {
        String[] cmdArray = cmd.getCmd();
        if (cmdArray == null || cmdArray.length == 0) {
            if (this.sshKeyStrategy.getInjectedKey() != null) {
                cmd.withCmd(new String[]{"/usr/sbin/sshd", "-D", "-p", String.valueOf(this.port), "-o", "AuthorizedKeysCommand=/root/authorized_key", "-o", "AuthorizedKeysCommandUser=root"});
            } else {
                cmd.withCmd(new String[]{"/usr/sbin/sshd", "-D", "-p", String.valueOf(this.port)});
            }
        }
        cmd.withPortSpecs(new String[]{this.port + "/tcp"});
        PortBinding sshPortBinding = PortBinding.parse((String)(":" + this.port));
        Ports portBindings = cmd.getPortBindings();
        if (portBindings != null) {
            portBindings.add(new PortBinding[]{sshPortBinding});
            cmd.withPortBindings(portBindings);
        } else {
            cmd.withPortBindings(new PortBinding[]{sshPortBinding});
        }
        cmd.withExposedPorts(new ExposedPort[]{ExposedPort.parse((String)(this.port + "/tcp"))});
    }

    @Override
    public void beforeContainerStarted(DockerAPI api, String workdir, String containerId) throws IOException, InterruptedException {
        String key = this.sshKeyStrategy.getInjectedKey();
        if (key != null) {
            String AuthorizedKeysCommand = "#!/bin/sh\n[ \"$1\" = \"" + this.sshKeyStrategy.getUser() + "\" ] && echo '" + key + "'|| :";
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)bos);){
                TarArchiveEntry entry = new TarArchiveEntry("authorized_key");
                entry.setSize((long)AuthorizedKeysCommand.getBytes().length);
                entry.setMode(448);
                tar.putArchiveEntry((ArchiveEntry)entry);
                tar.write(AuthorizedKeysCommand.getBytes());
                tar.closeArchiveEntry();
                tar.close();
                try (ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
                     DockerClient client = api.getClient();){
                    client.copyArchiveToContainerCmd(containerId).withTarInputStream((InputStream)is).withRemotePath("/root").exec();
                }
            }
        }
    }

    @Override
    protected ComputerLauncher createLauncher(DockerAPI api, String workdir, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        Integer retryWaitTimeOrNull;
        if ("exited".equals(inspect.getState().getStatus())) {
            LOGGER.error("Failed to launch docker SSH agent :" + inspect.getState().getExitCode());
            throw new IOException("Failed to launch docker SSH agent. Container exited with status " + inspect.getState().getExitCode());
        }
        LOGGER.debug("container created {}", (Object)inspect);
        InetSocketAddress address = this.getBindingForPort(api, inspect, this.port);
        PortUtils.ConnectionCheck connectionCheck = PortUtils.connectionCheck(address);
        Integer maxNumRetriesOrNull = this.getMaxNumRetries();
        if (maxNumRetriesOrNull != null) {
            connectionCheck.withRetries(maxNumRetriesOrNull);
        }
        if ((retryWaitTimeOrNull = this.getRetryWaitTime()) != null) {
            connectionCheck.withEveryRetryWaitFor(retryWaitTimeOrNull, TimeUnit.SECONDS);
        }
        long timestampBeforeConnectionCheck = System.nanoTime();
        if (!connectionCheck.execute() || !connectionCheck.useSSH().execute()) {
            long timestampAfterConnectionCheckEnded = System.nanoTime();
            long nanosecondsElapsed = timestampAfterConnectionCheckEnded - timestampBeforeConnectionCheck;
            long secondsElapsed = TimeUnit.NANOSECONDS.toSeconds(nanosecondsElapsed);
            throw new IOException("SSH service hadn't started after " + secondsElapsed + " seconds.");
        }
        return this.sshKeyStrategy.getSSHLauncher(address, this);
    }

    private InetSocketAddress getBindingForPort(DockerAPI api, InspectContainerResponse ir, int internalPort) {
        Ports.Binding[] sshBindings;
        ExposedPort sshPort = new ExposedPort(internalPort);
        Integer port = 22;
        NetworkSettings networkSettings = ir.getNetworkSettings();
        Ports ports = networkSettings.getPorts();
        Map bindings = ports.getBindings();
        for (Ports.Binding b : sshBindings = (Ports.Binding[])bindings.get(sshPort)) {
            String hps = b.getHostPortSpec();
            port = Integer.valueOf(hps);
        }
        String host = this.getExternalIP(api, ir, networkSettings, sshBindings);
        return new InetSocketAddress(host, (int)port);
    }

    private String getExternalIP(DockerAPI api, InspectContainerResponse ir, NetworkSettings networkSettings, Ports.Binding[] sshBindings) {
        String driver;
        String dockerHostname = api.getHostname();
        if (dockerHostname != null && !dockerHostname.trim().isEmpty()) {
            return dockerHostname;
        }
        if (api.isSwarm()) {
            for (Ports.Binding b : sshBindings) {
                String ipAddress = b.getHostIp();
                if (ipAddress == null || "0.0.0.0".equals(ipAddress)) continue;
                return ipAddress;
            }
        }
        if ((driver = ir.getExecDriver()) != null && driver.startsWith("sdc")) {
            return networkSettings.getIpAddress();
        }
        URI uri = URI.create(api.getDockerHost().getUri());
        if (uri.getScheme().equals("unix")) {
            return "0.0.0.0";
        }
        return uri.getHost();
    }

    private static class DockerSSHLauncher
    extends SSHLauncher {
        private String user;
        private String privateKey;

        public DockerSSHLauncher(String host, int port, String user, String privateKey, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime, SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
            super(host, port, "InstanceIdentity", jvmOptions, javaPath, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime, sshHostKeyVerificationStrategy);
            this.user = user;
            this.privateKey = privateKey;
        }

        public StandardUsernameCredentials getCredentials() {
            return new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, "InstanceIdentity", this.user, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(this.privateKey), null, "private key for docker ssh agent");
        }
    }

    public static class ManuallyConfiguredSSHKey
    extends SSHKeyStrategy {
        private final String credentialsId;
        private final SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy;

        @DataBoundConstructor
        public ManuallyConfiguredSSHKey(String credentialsId, SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
            this.credentialsId = credentialsId;
            this.sshHostKeyVerificationStrategy = sshHostKeyVerificationStrategy;
        }

        public String getCredentialsId() {
            return this.credentialsId;
        }

        @Override
        public String getUser() {
            return SSHLauncher.lookupSystemCredentials((String)this.credentialsId).getUsername();
        }

        public SshHostKeyVerificationStrategy getSshHostKeyVerificationStrategy() {
            return this.sshHostKeyVerificationStrategy;
        }

        @Override
        public ComputerLauncher getSSHLauncher(InetSocketAddress address, DockerComputerSSHConnector connector) throws IOException {
            return new SSHLauncher(address.getHostString(), address.getPort(), this.getCredentialsId(), connector.jvmOptions, connector.javaPath, connector.prefixStartSlaveCmd, connector.suffixStartSlaveCmd, connector.launchTimeoutSeconds, connector.maxNumRetries, connector.retryWaitTime, this.sshHostKeyVerificationStrategy);
        }

        @Override
        public String getInjectedKey() throws IOException {
            return null;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<SSHKeyStrategy> {
            @Nonnull
            public String getDisplayName() {
                return "Use configured SSH credentials";
            }

            public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
                return DockerTemplateBase.DescriptorImpl.doFillCredentialsIdItems(context);
            }
        }
    }

    public static class InjectSSHKey
    extends SSHKeyStrategy {
        private final String user;

        @DataBoundConstructor
        public InjectSSHKey(String user) {
            this.user = user;
        }

        @Override
        public String getUser() {
            return this.user;
        }

        @Override
        public ComputerLauncher getSSHLauncher(InetSocketAddress address, DockerComputerSSHConnector connector) throws IOException {
            InstanceIdentity id = InstanceIdentity.get();
            String pem = PEMEncodable.create((Key)id.getPrivate()).encode();
            return new DockerSSHLauncher(address.getHostString(), address.getPort(), this.user, pem, connector.jvmOptions, connector.javaPath, connector.prefixStartSlaveCmd, connector.suffixStartSlaveCmd, connector.launchTimeoutSeconds, connector.maxNumRetries, connector.retryWaitTime, (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        }

        @Override
        public String getInjectedKey() throws IOException {
            InstanceIdentity id = InstanceIdentity.get();
            return "ssh-rsa " + Base64.encode((byte[])new RSAKeyAlgorithm().encodePublicKey(id.getPublic()));
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<SSHKeyStrategy> {
            @Nonnull
            public String getDisplayName() {
                return "Inject SSH key";
            }
        }
    }

    public static abstract class SSHKeyStrategy
    extends AbstractDescribableImpl<SSHKeyStrategy> {
        public abstract String getInjectedKey() throws IOException;

        public abstract String getUser();

        public abstract ComputerLauncher getSSHLauncher(InetSocketAddress var1, DockerComputerSSHConnector var2) throws IOException;
    }

    @Extension
    @Symbol(value={"ssh"})
    public static final class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public String getDisplayName() {
            return "Connect with SSH";
        }

        public List getSSHKeyStrategyDescriptors() {
            return Jenkins.getInstance().getDescriptorList(SSHKeyStrategy.class);
        }
    }
}

