/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.google.common.base.Joiner;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProperty;
import hudson.util.LogTaskListener;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.client.DockerEnvUtils;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerComputerJNLPConnector
extends DockerComputerConnector {
    private static final Logger LOGGER = Logger.getLogger(DockerComputerJNLPConnector.class.getCanonicalName());
    private static final TaskListener LOGGER_LISTENER = new LogTaskListener(LOGGER, Level.FINER);
    private String user;
    private final JNLPLauncher jnlpLauncher;
    private String jenkinsUrl;
    private String[] entryPointArguments;
    private static final String DEFAULT_ENTRY_POINT_ARGUMENTS = "${" + ArgumentVariables.TunnelArgument.getName() + "}\n${" + ArgumentVariables.TunnelValue.getName() + "}\n-url\n${" + ArgumentVariables.JenkinsUrl.getName() + "}\n${" + ArgumentVariables.Secret.getName() + "}\n${" + ArgumentVariables.NodeName.getName() + "}";

    @DataBoundConstructor
    public DockerComputerJNLPConnector(JNLPLauncher jnlpLauncher) {
        this.jnlpLauncher = jnlpLauncher;
    }

    public String getUser() {
        return this.user;
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = user;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
    }

    @CheckForNull
    public String[] getEntryPointArguments() {
        return this.entryPointArguments;
    }

    @CheckForNull
    public String getEntryPointArgumentsString() {
        if (this.entryPointArguments == null) {
            return null;
        }
        return Joiner.on((String)"\n").join((Object[])this.entryPointArguments);
    }

    @DataBoundSetter
    public void setEntryPointArgumentsString(String entryPointArgumentsString) {
        this.setEntryPointArguments(DockerTemplateBase.splitAndFilterEmpty(entryPointArgumentsString, "\n"));
    }

    public void setEntryPointArguments(String[] entryPointArguments) {
        this.entryPointArguments = entryPointArguments == null || entryPointArguments.length == 0 ? null : entryPointArguments;
    }

    public DockerComputerJNLPConnector withUser(String user) {
        this.user = user;
        return this;
    }

    public DockerComputerJNLPConnector withJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
        return this;
    }

    public DockerComputerJNLPConnector withEntryPointArguments(String ... args) {
        this.setEntryPointArguments(args);
        return this;
    }

    public JNLPLauncher getJnlpLauncher() {
        return this.jnlpLauncher;
    }

    @Override
    protected ComputerLauncher createLauncher(DockerAPI api, String workdir, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        return new JNLPLauncher();
    }

    @Override
    public void beforeContainerCreated(DockerAPI api, String workdir, CreateContainerCmd cmd) throws IOException, InterruptedException {
        String effectiveJenkinsUrl = StringUtils.isEmpty((String)this.jenkinsUrl) ? Jenkins.getInstance().getRootUrl() : this.jenkinsUrl;
        String nodeName = DockerTemplate.getNodeNameFromContainerConfig(cmd);
        String secret = JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(nodeName);
        EnvVars knownVariables = this.calculateVariablesForVariableSubstitution(nodeName, secret, this.jnlpLauncher.tunnel, effectiveJenkinsUrl);
        String configuredArgString = this.getEntryPointArgumentsString();
        String effectiveConfiguredArgString = StringUtils.isNotBlank((String)configuredArgString) ? configuredArgString : DEFAULT_ENTRY_POINT_ARGUMENTS;
        String resolvedArgString = Util.replaceMacro((String)effectiveConfiguredArgString, (Map)knownVariables);
        String[] resolvedArgs = DockerTemplateBase.splitAndFilterEmpty(resolvedArgString, "\n");
        cmd.withCmd(resolvedArgs);
        String vmargs = this.jnlpLauncher.vmargs;
        if (StringUtils.isNotBlank((String)vmargs)) {
            DockerEnvUtils.addEnvToCmd("JAVA_OPT", vmargs.trim(), cmd);
        }
        if (StringUtils.isNotBlank((String)this.user)) {
            cmd.withUser(this.user);
        }
    }

    @Override
    public void afterContainerStarted(DockerAPI api, String workdir, String containerId) throws IOException, InterruptedException {
    }

    private EnvVars calculateVariablesForVariableSubstitution(String nodeName, String secret, String jnlpTunnel, String jenkinsUrl) throws IOException, InterruptedException {
        EnvVars knownVariables = new EnvVars();
        Jenkins j = Jenkins.getInstance();
        DockerComputerJNLPConnector.addEnvVars(knownVariables, j.getGlobalNodeProperties());
        for (ArgumentVariables v : ArgumentVariables.values()) {
            String argValue;
            switch (v) {
                case JenkinsUrl: {
                    argValue = jenkinsUrl;
                    break;
                }
                case TunnelArgument: {
                    argValue = StringUtils.isNotBlank((String)jnlpTunnel) ? "-tunnel" : "";
                    break;
                }
                case TunnelValue: {
                    argValue = jnlpTunnel;
                    break;
                }
                case Secret: {
                    argValue = secret;
                    break;
                }
                case NodeName: {
                    argValue = nodeName;
                    break;
                }
                default: {
                    String msg = "Internal code error: Switch statement is missing \"case " + v.name() + " : argValue = ... ; break;\" code.";
                    throw new RuntimeException(msg);
                }
            }
            DockerComputerJNLPConnector.addEnvVar(knownVariables, v.getName(), argValue);
        }
        return knownVariables;
    }

    private static void addEnvVars(EnvVars vars, Iterable<? extends NodeProperty<?>> nodeProperties) throws IOException, InterruptedException {
        if (nodeProperties != null) {
            for (NodeProperty<?> nodeProperty : nodeProperties) {
                nodeProperty.buildEnvVars(vars, LOGGER_LISTENER);
            }
        }
    }

    private static void addEnvVar(EnvVars vars, String name, Object valueOrNull) {
        vars.put(name, valueOrNull == null ? "" : valueOrNull.toString());
    }

    @Extension
    @Symbol(value={"jnlp"})
    public static final class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public Collection<ArgumentVariables> getEntryPointArgumentVariables() {
            return Arrays.asList(ArgumentVariables.values());
        }

        public Collection<String> getDefaultEntryPointArguments() {
            String[] args = DockerTemplateBase.splitAndFilterEmpty(DEFAULT_ENTRY_POINT_ARGUMENTS, "\n");
            return Arrays.asList(args);
        }

        public String getDisplayName() {
            return "Connect with JNLP";
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static enum ArgumentVariables {
        NodeName("NODE_NAME", "The name assigned to this node"),
        Secret("JNLP_SECRET", "The secret that must be passed to slave.jar's -secret argument to pass JNLP authentication."),
        JenkinsUrl("JENKINS_URL", "The Jenkins root URL."),
        TunnelArgument("TUNNEL_ARG", "If a JNLP tunnel has been specified then this evaluates to '-tunnel', otherwise it evaluates to the empty string"),
        TunnelValue("TUNNEL", "The JNLP tunnel value");

        private final String name;
        private final String description;

        private ArgumentVariables(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

