/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerMultiplexedInputStream
extends InputStream {
    private final InputStream multiplexed;
    int next;
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerMultiplexedInputStream.class);

    public DockerMultiplexedInputStream(InputStream in) {
        this.multiplexed = in;
        this.next = 0;
    }

    @Override
    public int read() throws IOException {
        this.readInternal();
        --this.next;
        return this.multiplexed.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readInternal();
        int byteRead = this.multiplexed.read(b, off, Math.min(this.next, len));
        this.next -= byteRead;
        return byteRead;
    }

    private void readInternal() throws IOException {
        block4: while (this.next == 0) {
            int i;
            byte[] header = new byte[8];
            for (int todo = 8; todo > 0; todo -= i) {
                i = this.multiplexed.read(header, 8 - todo, todo);
                if (i >= 0) continue;
                return;
            }
            int size = ((header[4] & 0xFF) << 24) + ((header[5] & 0xFF) << 16) + ((header[6] & 0xFF) << 8) + (header[7] & 0xFF);
            switch (header[0]) {
                case 1: {
                    this.next = size;
                    continue block4;
                }
                case 2: {
                    int received;
                    int i2;
                    byte[] payload = new byte[size];
                    for (received = 0; received < size && (i2 = this.multiplexed.read(payload, received, size - received)) >= 0; received += i2) {
                    }
                    LOGGER.warn("Unexpected data on container stderr: {}", (Object)new String(payload, 0, received, StandardCharsets.UTF_8));
                    continue block4;
                }
            }
            throw new IOException("Unexpected application/vnd.docker.raw-stream frame type " + header);
        }
    }
}

