/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.client;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.SSLConfig;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.docker.client.DelegatingDockerClient;
import io.jenkins.docker.client.DockerClientParameters;
import io.jenkins.docker.client.DockerServerCredentialsSSLConfig;
import io.jenkins.docker.client.NettyDockerCmdExecFactory;
import io.jenkins.docker.client.UsageTrackingCache;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerAPI
extends AbstractDescribableImpl<DockerAPI>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerAPI.class);
    private static final long serialVersionUID = 1L;
    private DockerServerEndpoint dockerHost;
    private int connectTimeout;
    private int readTimeout;
    private String apiVersion;
    private String hostname;
    private transient Boolean _isSwarm;
    private static final UsageTrackingCache<DockerClientParameters, SharableDockerClient> CLIENT_CACHE;

    @DataBoundConstructor
    public DockerAPI(DockerServerEndpoint dockerHost) {
        this.dockerHost = dockerHost;
    }

    public DockerAPI(DockerServerEndpoint dockerHost, int connectTimeout, int readTimeout, String apiVersion, String hostname) {
        this.dockerHost = dockerHost;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.apiVersion = apiVersion;
        this.hostname = hostname;
    }

    public DockerServerEndpoint getDockerHost() {
        return this.dockerHost;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @DataBoundSetter
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @DataBoundSetter
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    @DataBoundSetter
    public void setApiVersion(String apiVersion) {
        this.apiVersion = StringUtils.trimToNull((String)apiVersion);
    }

    public String getHostname() {
        return this.hostname;
    }

    @DataBoundSetter
    public void setHostname(String hostname) {
        this.hostname = StringUtils.trimToNull((String)hostname);
    }

    public boolean isSwarm() {
        if (this._isSwarm == null) {
            try (DockerClient client = this.getClient();){
                Version remoteVersion = (Version)client.versionCmd().exec();
                this._isSwarm = remoteVersion.getVersion().startsWith("swarm");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this._isSwarm;
    }

    public DockerClient getClient() {
        return this.getClient(this.readTimeout);
    }

    public DockerClient getClient(int activityTimeoutInSeconds) {
        return DockerAPI.getOrMakeClient(this.dockerHost.getUri(), this.dockerHost.getCredentialsId(), activityTimeoutInSeconds, this.connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DockerClient getOrMakeClient(String dockerUri, String credentialsId, int readTimeout, int connectTimeout) {
        Integer readTimeoutInMillisecondsOrNull = readTimeout > 0 ? Integer.valueOf(readTimeout * 1000) : null;
        Integer connectTimeoutInMillisecondsOrNull = connectTimeout > 0 ? Integer.valueOf(connectTimeout * 1000) : null;
        DockerClientParameters cacheKey = new DockerClientParameters(dockerUri, credentialsId, readTimeoutInMillisecondsOrNull, connectTimeoutInMillisecondsOrNull);
        UsageTrackingCache<DockerClientParameters, SharableDockerClient> usageTrackingCache = CLIENT_CACHE;
        synchronized (usageTrackingCache) {
            SharableDockerClient client = CLIENT_CACHE.getAndIncrementUsage(cacheKey);
            if (client == null) {
                client = DockerAPI.makeClient(dockerUri, credentialsId, readTimeoutInMillisecondsOrNull, connectTimeoutInMillisecondsOrNull);
                LOGGER.info("Cached connection {} to {}", (Object)client, (Object)cacheKey);
                CLIENT_CACHE.cacheAndIncrementUsage(cacheKey, client);
            }
            return client;
        }
    }

    private static SharableDockerClient makeClient(String dockerUri, String credentialsId, Integer readTimeoutInMillisecondsOrNull, Integer connectTimeoutInMillisecondsOrNull) {
        DockerClient actualClient = DockerClientBuilder.getInstance((DefaultDockerClientConfig.Builder)new DefaultDockerClientConfig.Builder().withDockerHost(dockerUri).withCustomSslConfig(DockerAPI.toSSlConfig(credentialsId))).withDockerCmdExecFactory((DockerCmdExecFactory)new NettyDockerCmdExecFactory().withReadTimeout(readTimeoutInMillisecondsOrNull).withConnectTimeout(connectTimeoutInMillisecondsOrNull)).build();
        SharableDockerClient multiUsageClient = new SharableDockerClient(actualClient);
        return multiUsageClient;
    }

    private static SSLConfig toSSlConfig(String credentialsId) {
        if (credentialsId == null) {
            return null;
        }
        DockerServerCredentials credentials = (DockerServerCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(DockerServerCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        return credentials == null ? null : new DockerServerCredentialsSSLConfig(credentials);
    }

    public Socket getSocket() throws IOException {
        try {
            URI uri = new URI(this.dockerHost.getUri());
            if ("unix".equals(uri.getScheme())) {
                AFUNIXSocketAddress unix = new AFUNIXSocketAddress(new File("/var/run/docker.sock"));
                AFUNIXSocket socket = AFUNIXSocket.newInstance();
                socket.connect((SocketAddress)unix);
                return socket;
            }
            SSLConfig sslConfig = DockerAPI.toSSlConfig(this.dockerHost.getCredentialsId());
            if (sslConfig != null) {
                return sslConfig.getSSLContext().getSocketFactory().createSocket(uri.getHost(), uri.getPort());
            }
            return new Socket(uri.getHost(), uri.getPort());
        }
        catch (Exception e) {
            throw new IOException("Failed to create a Socker for docker URI " + this.dockerHost.getUri(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerAPI dockerAPI = (DockerAPI)o;
        if (this.connectTimeout != dockerAPI.connectTimeout) {
            return false;
        }
        if (this.readTimeout != dockerAPI.readTimeout) {
            return false;
        }
        if (this.dockerHost != null ? !this.dockerHost.equals((Object)dockerAPI.dockerHost) : dockerAPI.dockerHost != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(dockerAPI.apiVersion) : dockerAPI.apiVersion != null) {
            return false;
        }
        return !(this.hostname != null ? !this.hostname.equals(dockerAPI.hostname) : dockerAPI.hostname != null);
    }

    public int hashCode() {
        int result = this.dockerHost != null ? this.dockerHost.hashCode() : 0;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + this.readTimeout;
        result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        return result;
    }

    static {
        UsageTrackingCache.ExpiryHandler<DockerClientParameters, SharableDockerClient> expiryHandler = new UsageTrackingCache.ExpiryHandler<DockerClientParameters, SharableDockerClient>(){

            @Override
            public void entryDroppedFromCache(DockerClientParameters cacheKey, SharableDockerClient client) {
                try {
                    client.reallyClose();
                    LOGGER.info("Dropped connection {} to {}", (Object)client, (Object)cacheKey);
                }
                catch (IOException ex) {
                    LOGGER.error("Dropped connection " + client + " to " + cacheKey + " but failed to close it:", (Throwable)ex);
                }
            }
        };
        CLIENT_CACHE = new UsageTrackingCache<DockerClientParameters, SharableDockerClient>(5L, TimeUnit.MINUTES, expiryHandler);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerAPI> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String value) {
            Jenkins ac;
            Object object = ac = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            if (!ac.hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(value);
            }
            return new StandardListBoxModel().includeAs(ACL.SYSTEM, context, DockerServerCredentials.class, Collections.emptyList());
        }

        public FormValidation doCheckConnectionTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckReadTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FormValidation doTestConnection(@QueryParameter String uri, @QueryParameter String credentialsId, @QueryParameter String apiVersion, @QueryParameter int connectTimeout, @QueryParameter int readTimeout) {
            try {
                DockerServerEndpoint dsep = new DockerServerEndpoint(uri, credentialsId);
                DockerAPI dapi = new DockerAPI(dsep, connectTimeout, readTimeout, apiVersion, null);
                try (DockerClient dc = dapi.getClient();){
                    VersionCmd vc = dc.versionCmd();
                    Version v = (Version)vc.exec();
                    String actualVersion = v.getVersion();
                    String actualApiVersion = v.getApiVersion();
                    FormValidation formValidation = FormValidation.ok((String)("Version = " + actualVersion + ", API Version = " + actualApiVersion));
                    return formValidation;
                }
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)e.getMessage());
            }
        }
    }

    private static class SharableDockerClient
    extends DelegatingDockerClient {
        public SharableDockerClient(DockerClient delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            UsageTrackingCache usageTrackingCache = CLIENT_CACHE;
            synchronized (usageTrackingCache) {
                CLIENT_CACHE.decrementUsage(this);
            }
        }

        public void reallyClose() throws IOException {
            this.getDelegate().close();
        }
    }
}

