/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker;

import com.google.common.base.Objects;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import hudson.EnvVars;
import hudson.model.Slave;
import hudson.slaves.SlaveComputer;
import io.jenkins.docker.DockerTransientNode;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public class DockerComputer
extends SlaveComputer {
    private static final Logger LOGGER = Logger.getLogger(DockerComputer.class.getName());

    public DockerComputer(DockerTransientNode node) {
        super((Slave)node);
    }

    @CheckForNull
    public DockerCloud getCloud() {
        DockerTransientNode node = this.getNode();
        return node == null ? null : node.getCloud();
    }

    @CheckForNull
    public DockerTransientNode getNode() {
        return (DockerTransientNode)super.getNode();
    }

    @CheckForNull
    public String getContainerId() {
        DockerTransientNode node = this.getNode();
        return node == null ? null : node.getContainerId();
    }

    @CheckForNull
    public String getCloudId() {
        DockerTransientNode node = this.getNode();
        return node == null ? null : node.getCloudId();
    }

    public EnvVars getEnvironment() throws IOException, InterruptedException {
        EnvVars variables = super.getEnvironment();
        variables.put("DOCKER_CONTAINER_ID", this.getContainerId());
        DockerCloud cloud = this.getCloud();
        if (cloud != null && cloud.isExposeDockerHost()) {
            variables.put("JENKINS_CLOUD_ID", cloud.name);
            String dockerHost = cloud.getDockerApi().getDockerHost().getUri();
            variables.put("DOCKER_HOST", dockerHost);
        }
        return variables;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("name", (Object)super.getName()).add("slave", (Object)this.getNode()).toString();
    }
}

