/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.listener;

import com.nirima.jenkins.plugins.docker.action.DockerBuildAction;
import com.nirima.jenkins.plugins.docker.action.DockerBuildImageAction;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.docker.DockerComputer;
import io.jenkins.docker.DockerTransientNode;
import java.util.List;
import java.util.logging.Logger;

@Extension
public class DockerRunListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(DockerRunListener.class.getName());

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        Computer computer = Computer.currentComputer();
        if (computer instanceof DockerComputer) {
            DockerTransientNode node = ((DockerComputer)computer).getNode();
            run.addAction((Action)new DockerBuildAction(node));
        }
    }

    public void onDeleted(Run<?, ?> run) {
        super.onDeleted(run);
        List actions = run.getActions(DockerBuildImageAction.class);
        for (DockerBuildImageAction action : actions) {
            if (!action.cleanupWithJenkinsJobDelete) continue;
            LOGGER.info("Attempting to clean up docker image for " + run);
            if (!action.pushOnSuccess) continue;
        }
    }
}

