/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.github.dockerjava.core.dockerfile.Dockerfile;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.action.DockerBuildImageAction;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import com.nirima.jenkins.plugins.docker.utils.LogUtils;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.VirtualChannel;
import hudson.slaves.Cloud;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.docker.client.DockerAPI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderPublisher
extends Builder
implements Serializable,
SimpleBuildStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerBuilderPublisher.class);
    private static final String TAG_REGEX = "[a-zA-Z0-9-_.]+";
    private static final String NAME_COMPONENT_REGEX = "[a-z0-9-_.]+";
    private static final String REGISTRY_HOSTNAME_REGEX = "[a-zA-Z0-9-.]+(:[0-9]+)?";
    private static final String IMAGE_NAME_REGEX = "([a-zA-Z0-9-.]+(:[0-9]+)?/)?[a-z0-9-_.]+(/[a-z0-9-_.]+)*";
    private static final String VALID_REPO_REGEX = "^([a-zA-Z0-9-.]+(:[0-9]+)?/)?[a-z0-9-_.]+(/[a-z0-9-_.]+)*(:[a-zA-Z0-9-_.]+)?$";
    private static final Pattern VALID_REPO_PATTERN = Pattern.compile("^([a-zA-Z0-9-.]+(:[0-9]+)?/)?[a-z0-9-_.]+(/[a-z0-9-_.]+)*(:[a-zA-Z0-9-_.]+)?$");
    public final String dockerFileDirectory;
    private transient String pullCredentialsId;
    private DockerRegistryEndpoint fromRegistry;
    @Deprecated
    public String tag;
    @CheckForNull
    private List<String> tags;
    public final boolean pushOnSuccess;
    private String pushCredentialsId;
    private transient DockerRegistryEndpoint registry;
    public final boolean cleanImages;
    public final boolean cleanupWithJenkinsJobDelete;
    public final String cloud;

    @DataBoundConstructor
    public DockerBuilderPublisher(String dockerFileDirectory, DockerRegistryEndpoint fromRegistry, String cloud, String tagsString, boolean pushOnSuccess, String pushCredentialsId, boolean cleanImages, boolean cleanupWithJenkinsJobDelete) {
        this.dockerFileDirectory = dockerFileDirectory;
        this.fromRegistry = fromRegistry;
        this.setTagsString(tagsString);
        this.tag = null;
        this.cloud = cloud;
        this.pushOnSuccess = pushOnSuccess;
        this.pushCredentialsId = pushCredentialsId;
        this.cleanImages = cleanImages;
        this.cleanupWithJenkinsJobDelete = cleanupWithJenkinsJobDelete;
    }

    public DockerRegistryEndpoint getRegistry(Identifier identifier) {
        if (this.registry == null) {
            this.registry = new DockerRegistryEndpoint(null, this.pushCredentialsId);
        }
        return this.registry;
    }

    public String getPullCredentialsId() {
        return this.pullCredentialsId;
    }

    public String getPushCredentialsId() {
        return this.pushCredentialsId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getTagsString() {
        return this.getTags() == null ? "" : Joiner.on((String)"\n").join(this.getTags());
    }

    public void setTagsString(String tagsString) {
        this.setTags(DockerBuilderPublisher.filterStringToList(tagsString));
    }

    public DockerRegistryEndpoint getFromRegistry() {
        return this.fromRegistry;
    }

    public static List<String> filterStringToList(String str) {
        if (str == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String o : Splitter.on((String)"\n").omitEmptyStrings().trimResults().split((CharSequence)str)) {
            result.add(o);
        }
        return result;
    }

    public static void verifyTags(String tagsString) {
        List<String> verifyTags = DockerBuilderPublisher.filterStringToList(tagsString);
        for (String verifyTag : verifyTags) {
            String expandedTag = verifyTag.replaceAll("\\$\\{[^}]*NUMBER\\}", "1234").replaceAll("\\$\\{[^}]*\\}", "xyz");
            if (VALID_REPO_PATTERN.matcher(expandedTag).matches()) continue;
            throw new IllegalArgumentException("Tag " + verifyTag + " doesn't match " + VALID_REPO_REGEX);
        }
    }

    protected DockerCloud getCloud(Launcher launcher) {
        DockerCloud theCloud;
        if (!Strings.isNullOrEmpty((String)this.cloud)) {
            theCloud = JenkinsUtils.getServer(this.cloud);
        } else {
            Optional<DockerCloud> cloud = JenkinsUtils.getCloudForChannel(launcher.getChannel());
            if (!cloud.isPresent()) {
                throw new RuntimeException("Could not find the cloud this project was built on");
            }
            theCloud = cloud.get();
        }
        if (theCloud.isTriton()) {
            LOGGER.warn("Selected cloud for build does not support this feature. Finding an alternative");
            for (DockerCloud dc : JenkinsUtils.getServers()) {
                if (dc.isTriton()) continue;
                LOGGER.warn("Picked {} cloud instead", (Object)dc.getDisplayName());
                return dc;
            }
        }
        return theCloud;
    }

    public void perform(hudson.model.Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        List<String> expandedTags = this.expandTags(run, workspace, launcher, listener);
        String expandedDockerFileDirectory = this.dockerFileDirectory;
        try {
            expandedDockerFileDirectory = TokenMacro.expandAll(run, (FilePath)workspace, (TaskListener)listener, (String)this.dockerFileDirectory);
        }
        catch (MacroEvaluationException e) {
            listener.getLogger().println("Couldn't macro expand docker file directory " + this.dockerFileDirectory);
        }
        new Run(run, launcher, listener, new FilePath(workspace, expandedDockerFileDirectory), expandedTags, this.getCloud(launcher)).run();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private List<String> expandTags(hudson.model.Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        ArrayList<String> eTags = new ArrayList<String>(this.tags.size());
        for (String tag : this.tags) {
            try {
                eTags.add(TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)tag));
            }
            catch (IOException | InterruptedException | MacroEvaluationException e) {
                listener.getLogger().println("Couldn't macro expand tag " + tag);
            }
        }
        return eTags;
    }

    private Object readResolve() {
        if (this.pushCredentialsId == null && this.registry != null) {
            this.pushCredentialsId = this.registry.getCredentialsId();
        }
        if (this.pullCredentialsId != null) {
            this.fromRegistry = new DockerRegistryEndpoint(null, this.pullCredentialsId);
        }
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckTagsString(@QueryParameter String tagsString) {
            try {
                DockerBuilderPublisher.verifyTags(tagsString);
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillPullCredentialsIdItems(@AncestorInPath Item item) {
            return this.doFillRegistryCredentialsIdItems(item);
        }

        public ListBoxModel doFillPushCredentialsIdItems(@AncestorInPath Item item) {
            return this.doFillRegistryCredentialsIdItems(item);
        }

        private ListBoxModel doFillRegistryCredentialsIdItems(@AncestorInPath Item item) {
            DockerRegistryEndpoint.DescriptorImpl descriptor = (DockerRegistryEndpoint.DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(DockerRegistryEndpoint.class);
            return descriptor.doFillCredentialsIdItems(item);
        }

        public ListBoxModel doFillCloudItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Cloud this build is running on", "");
            for (Cloud cloud : DockerCloud.instances()) {
                model.add(cloud.name);
            }
            return model;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Build / Publish Docker Image";
        }
    }

    private static class DockerBuildCallable
    extends MasterToSlaveFileCallable<InputStream> {
        private DockerBuildCallable() {
        }

        public InputStream invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return new RemoteInputStream(new Dockerfile(new File(f, "Dockerfile"), f).parse().buildDockerFolderTar(), RemoteInputStream.Flag.GREEDY);
        }
    }

    class Run
    implements Serializable {
        final transient Launcher launcher;
        final TaskListener listener;
        final FilePath fpChild;
        final List<String> tagsToUse;
        private final DockerAPI dockerApi;
        final transient hudson.model.Run<?, ?> run;

        private Run(hudson.model.Run<?, ?> run, Launcher launcher, TaskListener listener, FilePath fpChild, List<String> tagsToUse, DockerCloud dockerCloud) {
            this.run = run;
            this.launcher = launcher;
            this.listener = listener;
            this.fpChild = fpChild;
            this.tagsToUse = tagsToUse;
            this.dockerApi = dockerCloud.getDockerApi();
        }

        private DockerAPI getDockerAPI() {
            Validate.notNull((Object)this.dockerApi, (String)"Could not get client because we could not find the cloud that the project was built on. Was this build run on Docker?");
            return this.dockerApi;
        }

        private DockerClient getClientWithNoTimeout() {
            return this.getDockerAPI().getClient(0);
        }

        private DockerClient getClient() {
            return this.getDockerAPI().getClient();
        }

        boolean run() throws IOException, InterruptedException {
            this.log("Docker Build");
            String imageId = this.buildImage();
            if (imageId == null) {
                return false;
            }
            this.log("Docker Build Response : " + imageId);
            this.run.addAction((Action)new DockerBuildImageAction(this.dockerApi.getDockerHost().getUri(), imageId, this.tagsToUse, DockerBuilderPublisher.this.cleanupWithJenkinsJobDelete, DockerBuilderPublisher.this.pushOnSuccess));
            this.run.save();
            if (DockerBuilderPublisher.this.pushOnSuccess) {
                this.log("Pushing " + this.tagsToUse);
                this.pushImages();
            }
            if (DockerBuilderPublisher.this.cleanImages) {
                this.log("Cleaning local images [" + imageId + "]");
                try {
                    this.cleanImages(imageId);
                }
                catch (Exception ex) {
                    this.log("Error attempting to clean images");
                }
            }
            this.log("Docker Build Done");
            return true;
        }

        private void cleanImages(String id) throws IOException {
            try (DockerClient client = this.getClient();){
                client.removeImageCmd(id).withForce(Boolean.valueOf(true)).exec();
            }
        }

        private String buildImage() throws IOException, InterruptedException {
            String imageId;
            AuthConfigurations auths = new AuthConfigurations();
            DockerRegistryEndpoint pullRegistry = DockerBuilderPublisher.this.getFromRegistry();
            if (pullRegistry != null && pullRegistry.getCredentialsId() != null) {
                auths.addConfig(DockerCloud.getAuthConfig(pullRegistry, this.run.getParent().getParent()));
            }
            this.log("Docker Build: building image at path " + this.fpChild.getRemote());
            InputStream tar = (InputStream)this.fpChild.act((FilePath.FileCallable)new DockerBuildCallable());
            BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

                public void onNext(BuildResponseItem item) {
                    String text = item.getStream();
                    if (text != null) {
                        Run.this.listener.getLogger().println(text);
                    }
                    super.onNext(item);
                }
            };
            try (DockerClient client = this.getClientWithNoTimeout();){
                imageId = ((BuildImageResultCallback)client.buildImageCmd(tar).withBuildAuthConfigs(auths).exec((ResultCallback)resultCallback)).awaitImageId();
                if (imageId == null) {
                    throw new AbortException("Built image id is null. Some error occured");
                }
                for (String tag : this.tagsToUse) {
                    NameParser.ReposTag reposTag = NameParser.parseRepositoryTag((String)tag);
                    String commitTag = StringUtils.isEmpty((String)reposTag.tag) ? "latest" : reposTag.tag;
                    this.log("Tagging built image with " + reposTag.repos + ":" + commitTag);
                    client.tagImageCmd(imageId, reposTag.repos, commitTag).withForce().exec();
                }
            }
            return imageId;
        }

        protected void log(String s) {
            this.listener.getLogger().println(s);
        }

        private void pushImages() throws IOException {
            for (String tagToUse : this.tagsToUse) {
                Identifier identifier = Identifier.fromCompoundString((String)tagToUse);
                PushImageResultCallback resultCallback = new PushImageResultCallback(){

                    public void onNext(PushResponseItem item) {
                        if (item == null) {
                            Run.this.log("Received NULL Push Response. Ignoring");
                            return;
                        }
                        LogUtils.printResponseItemToListener(Run.this.listener, (ResponseItem)item);
                        super.onNext(item);
                    }
                };
                try {
                    DockerClient client = this.getClientWithNoTimeout();
                    Throwable throwable = null;
                    try {
                        PushImageCmd cmd = client.pushImageCmd(identifier);
                        int i = identifier.repository.name.indexOf(47);
                        String registry = i >= 0 ? identifier.repository.name.substring(0, i) : null;
                        DockerCloud.setRegistryAuthentication(cmd, new DockerRegistryEndpoint(registry, DockerBuilderPublisher.this.pushCredentialsId), this.run.getParent().getParent());
                        ((PushImageResultCallback)cmd.exec((ResultCallback)resultCallback)).awaitSuccess();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (client == null) continue;
                        if (throwable != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        client.close();
                    }
                }
                catch (DockerException ex) {
                    this.log("Exception pushing docker image. Check that the destination registry is running.");
                    throw ex;
                }
            }
        }
    }
}

