/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionStopStart;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderControlOptionStop
extends DockerBuilderControlOptionStopStart {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuilderControlOptionStop.class);
    public final boolean remove;

    @DataBoundConstructor
    public DockerBuilderControlOptionStop(String cloudName, String containerId, boolean remove) {
        super(cloudName, containerId);
        this.remove = remove;
    }

    @Override
    public void execute(Run<?, ?> build, Launcher launcher, TaskListener listener) throws DockerException {
        PrintStream llog = listener.getLogger();
        LOG.info("Stopping container " + this.containerId);
        llog.println("Stopping container " + this.containerId);
        DockerCloud cloud = this.getCloud(build, launcher);
        DockerAPI dockerApi = cloud.getDockerApi();
        try (DockerClient client = dockerApi.getClient();){
            this.executeOnDocker(build, llog, client);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void executeOnDocker(Run<?, ?> build, PrintStream llog, DockerClient client) throws DockerException {
        try {
            client.stopContainerCmd(this.containerId).exec();
        }
        catch (NotModifiedException ex) {
            LOG.info("Already stopped.");
            llog.println("Already stopped.");
        }
        this.getLaunchAction(build).stopped(client, this.containerId);
        if (this.remove) {
            LOG.info("Removing container {}...", (Object)this.containerId);
            llog.println("Removing container " + this.containerId + "...");
            client.removeContainerCmd(this.containerId);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOption.DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Stop Container";
        }
    }
}

