/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerSimpleTemplate;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlCloudOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOption;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.io.PrintStream;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderControlOptionRun
extends DockerBuilderControlCloudOption {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuilderControlOptionRun.class);
    public final String image;
    private String pullCredentialsId;
    private transient DockerRegistryEndpoint registry;
    public final String dnsString;
    public final String network;
    public final String dockerCommand;
    public final String volumesString;
    public final String volumesFrom;
    public final String environmentsString;
    public final boolean privileged;
    public final boolean tty;
    public final String hostname;
    public final String bindPorts;
    public final Integer memoryLimit;
    public final Integer memorySwap;
    public final Integer cpuShares;
    public final Integer shmSize;
    public final boolean bindAllPorts;
    public final String macAddress;

    @DataBoundConstructor
    public DockerBuilderControlOptionRun(String cloudName, String image, String pullCredentialsId, String dnsString, String network, String dockerCommand, String volumesString, String volumesFrom, String environmentsString, String hostname, Integer memoryLimit, Integer memorySwap, Integer cpuShares, Integer shmSize, String bindPorts, boolean bindAllPorts, boolean privileged, boolean tty, String macAddress) {
        super(cloudName);
        this.image = image;
        this.pullCredentialsId = pullCredentialsId;
        this.dnsString = dnsString;
        this.network = network;
        this.dockerCommand = dockerCommand;
        this.volumesString = volumesString;
        this.volumesFrom = volumesFrom;
        this.environmentsString = environmentsString;
        this.privileged = privileged;
        this.tty = tty;
        this.hostname = hostname;
        this.bindPorts = bindPorts;
        this.memoryLimit = memoryLimit;
        this.memorySwap = memorySwap;
        this.cpuShares = cpuShares;
        this.shmSize = shmSize;
        this.bindAllPorts = bindAllPorts;
        this.macAddress = macAddress;
    }

    public DockerRegistryEndpoint getRegistry() {
        if (this.registry == null) {
            this.registry = new DockerRegistryEndpoint(null, this.pullCredentialsId);
        }
        return this.registry;
    }

    @Override
    public void execute(Run<?, ?> build, Launcher launcher, TaskListener listener) throws DockerException, IOException {
        PrintStream llog = listener.getLogger();
        DockerCloud cloud = this.getCloud(build, launcher);
        DockerAPI dockerApi = cloud.getDockerApi();
        String xImage = this.expand(build, this.image);
        String xCommand = this.expand(build, this.dockerCommand);
        String xHostname = this.expand(build, this.hostname);
        LOG.info("Pulling image {}", (Object)xImage);
        llog.println("Pulling image " + xImage);
        try (DockerClient clientWithoutReadTimeout = dockerApi.getClient(0);){
            this.executePullOnDocker(build, llog, xImage, clientWithoutReadTimeout);
        }
        var11_11 = null;
        try (DockerClient client = dockerApi.getClient();){
            this.executeOnDocker(build, llog, xImage, xCommand, xHostname, client);
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
    }

    private void executePullOnDocker(Run<?, ?> build, final PrintStream llog, String xImage, DockerClient client) throws DockerException {
        PullImageResultCallback resultCallback = new PullImageResultCallback(){

            public void onNext(PullResponseItem item) {
                if (item.getStatus() != null && item.getProgress() == null) {
                    llog.print(item.getId() + ":" + item.getStatus());
                    LOG.info("{} : {}", (Object)item.getId(), (Object)item.getStatus());
                }
                super.onNext(item);
            }
        };
        PullImageCmd cmd = client.pullImageCmd(xImage);
        DockerCloud.setRegistryAuthentication(cmd, this.getRegistry(), build.getParent().getParent());
        try {
            ((PullImageResultCallback)cmd.exec((ResultCallback)resultCallback)).awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new DockerClientException("Interrupted while pulling image", (Throwable)e);
        }
    }

    private void executeOnDocker(Run<?, ?> build, PrintStream llog, String xImage, String xCommand, String xHostname, DockerClient client) throws DockerException {
        try {
            client.inspectImageCmd(xImage).exec();
        }
        catch (NotFoundException e) {
            throw new DockerClientException("Failed to pull image: " + this.image, (Throwable)e);
        }
        DockerSimpleTemplate template = new DockerSimpleTemplate(xImage, this.pullCredentialsId, this.dnsString, this.network, xCommand, this.volumesString, this.volumesFrom, this.environmentsString, xHostname, this.memoryLimit, this.memorySwap, this.cpuShares, this.shmSize, this.bindPorts, this.bindAllPorts, this.privileged, this.tty, this.macAddress, null);
        LOG.info("Starting container for image {}", (Object)xImage);
        llog.println("Starting container for image " + xImage);
        String containerId = DockerCloud.runContainer(template, client);
        LOG.info("Started container {}", (Object)containerId);
        llog.println("Started container " + containerId);
        this.getLaunchAction(build).started(client, containerId);
    }

    private String expand(Run<?, ?> build, String text) {
        try {
            if (build instanceof AbstractBuild && !Strings.isNullOrEmpty((String)text)) {
                text = TokenMacro.expandAll((AbstractBuild)((AbstractBuild)build), (TaskListener)TaskListener.NULL, (String)text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOption.DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Run Container";
        }
    }
}

