/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerContainerLabelKeys;
import com.nirima.jenkins.plugins.docker.DockerDisabled;
import com.nirima.jenkins.plugins.docker.DockerImagePullStrategy;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import com.nirima.jenkins.plugins.docker.strategy.DockerOnceRetentionStrategy;
import com.nirima.jenkins.plugins.docker.utils.UniqueIdGenerator;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.RetentionStrategy;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerTemplate
implements Describable<DockerTemplate> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DockerTemplate.class.getName());
    private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator(36);
    private static final String DEFAULT_NAME = "docker";
    private int configVersion = 2;
    private final String labelString;
    private DockerComputerConnector connector;
    @Deprecated
    private transient DockerComputerLauncher launcher;
    public String remoteFs;
    public final int instanceCap;
    private Node.Mode mode = Node.Mode.NORMAL;
    private RetentionStrategy retentionStrategy = new DockerOnceRetentionStrategy(10);
    private DockerTemplateBase dockerTemplateBase;
    private boolean removeVolumes;
    private transient Set<LabelAtom> labelSet;
    @CheckForNull
    private DockerImagePullStrategy pullStrategy = DockerImagePullStrategy.PULL_LATEST;
    private int pullTimeout;
    private List<? extends NodeProperty<?>> nodeProperties = Collections.EMPTY_LIST;
    @CheckForNull
    private DockerDisabled disabled;
    @CheckForNull
    private String name;

    public DockerTemplate() {
        this.labelString = "";
        this.instanceCap = 1;
    }

    public DockerTemplate(@Nonnull DockerTemplateBase dockerTemplateBase, DockerComputerConnector connector, String labelString, String remoteFs, String instanceCapStr) {
        this(dockerTemplateBase, connector, labelString, instanceCapStr);
        this.setRemoteFs(remoteFs);
    }

    @DataBoundConstructor
    public DockerTemplate(@Nonnull DockerTemplateBase dockerTemplateBase, DockerComputerConnector connector, String labelString, String instanceCapStr) {
        this.dockerTemplateBase = dockerTemplateBase;
        this.connector = connector;
        this.labelString = Util.fixNull((String)labelString);
        this.instanceCap = Strings.isNullOrEmpty((String)instanceCapStr) ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.labelSet = Label.parse((String)labelString);
    }

    public static String[] filterStringArray(String[] arr) {
        return DockerTemplateBase.filterStringArray(arr);
    }

    public String getImage() {
        return this.dockerTemplateBase.getImage();
    }

    public String getDnsString() {
        return this.dockerTemplateBase.getDnsString();
    }

    @CheckForNull
    public String[] getVolumes() {
        return this.dockerTemplateBase.getVolumes();
    }

    public String getVolumesString() {
        return this.dockerTemplateBase.getVolumesString();
    }

    @Deprecated
    public String getVolumesFrom() {
        return this.dockerTemplateBase.getVolumesFrom();
    }

    public String[] getVolumesFrom2() {
        return this.dockerTemplateBase.getVolumesFrom2();
    }

    public String getVolumesFromString() {
        return this.dockerTemplateBase.getVolumesFromString();
    }

    @CheckForNull
    public String getMacAddress() {
        return this.dockerTemplateBase.getMacAddress();
    }

    public String getDisplayName() {
        return this.dockerTemplateBase.getDisplayName();
    }

    public Integer getMemoryLimit() {
        return this.dockerTemplateBase.getMemoryLimit();
    }

    public Integer getMemorySwap() {
        return this.dockerTemplateBase.getMemorySwap();
    }

    public Integer getCpuShares() {
        return this.dockerTemplateBase.getCpuShares();
    }

    public Integer getShmSize() {
        return this.dockerTemplateBase.getShmSize();
    }

    public String[] getDockerCommandArray() {
        return this.dockerTemplateBase.getDockerCommandArray();
    }

    public Iterable<PortBinding> getPortMappings() {
        return this.dockerTemplateBase.getPortMappings();
    }

    public String getEnvironmentsString() {
        return this.dockerTemplateBase.getEnvironmentsString();
    }

    @CheckForNull
    public List<String> getExtraHosts() {
        return this.dockerTemplateBase.getExtraHosts();
    }

    public String getExtraHostsString() {
        return this.dockerTemplateBase.getExtraHostsString();
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.dockerTemplateBase.getRegistry();
    }

    public CreateContainerCmd fillContainerConfig(CreateContainerCmd containerConfig) {
        CreateContainerCmd result = this.dockerTemplateBase.fillContainerConfig(containerConfig);
        String templateName = this.getName();
        Map labels = result.getLabels();
        labels.put(DockerContainerLabelKeys.REMOVE_VOLUMES, Boolean.toString(this.isRemoveVolumes()));
        labels.put(DockerContainerLabelKeys.TEMPLATE_NAME, templateName);
        String nodeName = DockerTemplate.calcUnusedNodeName(templateName);
        DockerTemplate.setNodeNameInContainerConfig(result, nodeName);
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setNodeNameInContainerConfig(CreateContainerCmd containerConfig, String nodeName) {
        containerConfig.getLabels().put(DockerContainerLabelKeys.NODE_NAME, nodeName);
    }

    public static String getNodeNameFromContainerConfig(CreateContainerCmd containerConfig) {
        return (String)containerConfig.getLabels().get(DockerContainerLabelKeys.NODE_NAME);
    }

    public String getFullImageId() {
        return this.dockerTemplateBase.getFullImageId();
    }

    public DockerTemplateBase getDockerTemplateBase() {
        return this.dockerTemplateBase;
    }

    public boolean isRemoveVolumes() {
        return this.removeVolumes;
    }

    @DataBoundSetter
    public void setRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
    }

    public String getLabelString() {
        return this.labelString;
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public int getNumExecutors() {
        return 1;
    }

    @DataBoundSetter
    public void setRetentionStrategy(DockerOnceRetentionStrategy retentionStrategy) {
        this.retentionStrategy = retentionStrategy;
    }

    public RetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public DockerComputerConnector getConnector() {
        return this.connector;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    @DataBoundSetter
    public void setRemoteFs(String remoteFs) {
        this.remoteFs = remoteFs;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public DockerImagePullStrategy getPullStrategy() {
        return this.pullStrategy;
    }

    @DataBoundSetter
    public void setPullStrategy(DockerImagePullStrategy pullStrategy) {
        this.pullStrategy = pullStrategy;
    }

    public int getPullTimeout() {
        return this.pullTimeout;
    }

    @DataBoundSetter
    public void setPullTimeout(int pullTimeout) {
        this.pullTimeout = pullTimeout;
    }

    public List<? extends NodeProperty<?>> getNodeProperties() {
        return Collections.unmodifiableList(this.nodeProperties);
    }

    @DataBoundSetter
    public void setNodeProperties(List<? extends NodeProperty<?>> nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    public DockerDisabled getDisabled() {
        return this.disabled == null ? new DockerDisabled() : this.disabled;
    }

    @DataBoundSetter
    public void setDisabled(DockerDisabled disabled) {
        this.disabled = disabled;
    }

    @DataBoundSetter
    public void setName(String name) {
        String trimmedName;
        this.name = name == null ? null : ((trimmedName = name.trim()).equals(DEFAULT_NAME) || trimmedName.isEmpty() ? null : trimmedName);
    }

    public String getName() {
        if (this.name == null || this.name.trim().isEmpty()) {
            return DEFAULT_NAME;
        }
        return this.name.trim();
    }

    private void configDefaults() {
        if (this.mode == null) {
            this.mode = Node.Mode.NORMAL;
        }
        if (this.retentionStrategy == null) {
            this.retentionStrategy = new DockerOnceRetentionStrategy(10);
        }
        if (this.pullStrategy == null) {
            this.pullStrategy = DockerImagePullStrategy.PULL_LATEST;
        }
        if (this.nodeProperties == null) {
            this.nodeProperties = new DescribableList((Saveable)Jenkins.getInstance());
        }
    }

    public Object readResolve() {
        try {
            if (this.configVersion < 2) {
                DockerOnceRetentionStrategy tmpStrategy;
                if (this.retentionStrategy instanceof DockerOnceRetentionStrategy && (tmpStrategy = (DockerOnceRetentionStrategy)this.retentionStrategy).getIdleMinutes() == 0) {
                    this.setRetentionStrategy(new DockerOnceRetentionStrategy(10));
                }
                this.configVersion = 2;
            } else {
                this.configDefaults();
            }
            try {
                this.labelSet = Label.parse((String)this.labelString);
            }
            catch (Throwable t) {
                LOGGER.error("Can't parse labels: ", t);
            }
            if (this.connector == null && this.launcher != null) {
                this.connector = this.launcher.convertToConnector();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Can't convert old values to new (double conversion?): ", t);
        }
        return this;
    }

    @Restricted(value={NoExternalUse.class})
    public DockerTemplate cloneWithLabel(String label) {
        DockerTemplate template = new DockerTemplate(this.dockerTemplateBase, this.connector, label, this.remoteFs, "1");
        template.setMode(Node.Mode.EXCLUSIVE);
        template.setPullStrategy(this.pullStrategy);
        template.setRemoveVolumes(this.removeVolumes);
        template.setRetentionStrategy((DockerOnceRetentionStrategy)this.retentionStrategy);
        template.setNodeProperties(this.nodeProperties);
        return template;
    }

    public String toString() {
        return "DockerTemplate{configVersion=" + this.configVersion + ", labelString='" + this.labelString + '\'' + ", connector=" + (Object)((Object)this.connector) + ", remoteFs='" + this.remoteFs + '\'' + ", instanceCap=" + this.instanceCap + ", mode=" + this.mode + ", retentionStrategy=" + this.retentionStrategy + ", dockerTemplateBase=" + this.dockerTemplateBase + ", removeVolumes=" + this.removeVolumes + ", pullStrategy=" + (Object)((Object)this.pullStrategy) + ", nodeProperties=" + this.nodeProperties + ", disabled=" + this.disabled + '}';
    }

    public String getShortDescription() {
        return Objects.toStringHelper((Object)this).add("image", (Object)this.dockerTemplateBase.getImage()).toString();
    }

    public Descriptor<DockerTemplate> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    InspectImageResponse pullImage(DockerAPI api, final TaskListener listener) throws IOException, InterruptedException {
        InspectImageResponse result;
        boolean shouldPullImage;
        String image = this.getFullImageId();
        try (DockerClient client = api.getClient();){
            shouldPullImage = this.pullStrategy.shouldPullImage(client, image);
        }
        if (shouldPullImage) {
            LOGGER.info("Pulling image '{}'. This may take awhile...", (Object)image);
            long startTime = System.currentTimeMillis();
            try (DockerClient client = api.getClient(this.pullTimeout);){
                PullImageCmd cmd = client.pullImageCmd(image);
                DockerRegistryEndpoint registry = this.getRegistry();
                DockerCloud.setRegistryAuthentication(cmd, registry, (ItemGroup)Jenkins.getInstance());
                (cmd.exec((ResultCallback)new PullImageResultCallback(){

                    public void onNext(PullResponseItem item) {
                        listener.getLogger().println(item.getStatus());
                    }
                })).awaitCompletion();
            }
            long pullTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Finished pulling image '{}', took {} ms", (Object)image, (Object)pullTime);
        }
        try (DockerClient client = api.getClient();){
            result = client.inspectImageCmd(image).exec();
        }
        catch (NotFoundException e) {
            throw new DockerClientException("Could not pull image: " + image, (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Restricted(value={NoExternalUse.class})
    public DockerTransientNode provisionNode(DockerAPI api, TaskListener listener) throws IOException, Descriptor.FormException, InterruptedException {
        try {
            InspectImageResponse image = this.pullImage(api, listener);
            if (StringUtils.isBlank((String)this.remoteFs)) {
                this.remoteFs = image.getContainerConfig().getWorkingDir();
            }
            if (StringUtils.isBlank((String)this.remoteFs)) {
                this.remoteFs = "/";
            }
            try (DockerClient client = api.getClient();){
                DockerTransientNode dockerTransientNode = this.doProvisionNode(api, client, listener);
                return dockerTransientNode;
            }
        }
        catch (Descriptor.FormException | IOException | InterruptedException | RuntimeException ex) {
            DockerCloud ourCloud = DockerCloud.findCloudForTemplate(this);
            long milliseconds = ourCloud == null ? 0L : ourCloud.getEffectiveErrorDurationInMilliseconds();
            if (milliseconds <= 0L) throw ex;
            String reason = "Template provisioning failed.";
            DockerDisabled reasonForDisablement = this.getDisabled();
            reasonForDisablement.disableBySystem("Template provisioning failed.", milliseconds, ex);
            this.setDisabled(reasonForDisablement);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DockerTransientNode doProvisionNode(DockerAPI api, DockerClient client, TaskListener listener) throws IOException, Descriptor.FormException, InterruptedException {
        LOGGER.info("Trying to run container for {}", (Object)this.getImage());
        DockerComputerConnector connector = this.getConnector();
        CreateContainerCmd cmd = client.createContainerCmd(this.getImage());
        this.fillContainerConfig(cmd);
        connector.beforeContainerCreated(api, this.remoteFs, cmd);
        String nodeName = DockerTemplate.getNodeNameFromContainerConfig(cmd);
        LOGGER.info("Trying to run container for node {} from image: {}", (Object)nodeName, (Object)this.getImage());
        boolean finallyRemoveTheContainer = true;
        String containerId = cmd.exec().getId();
        LOGGER.info("Started container ID {} for node {} from image: {}", new Object[]{containerId, nodeName, this.getImage()});
        try {
            connector.beforeContainerStarted(api, this.remoteFs, containerId);
            client.startContainerCmd(containerId).exec();
            connector.afterContainerStarted(api, this.remoteFs, containerId);
            ComputerLauncher launcher = connector.createLauncher(api, containerId, this.remoteFs, listener);
            DockerTransientNode node = new DockerTransientNode(nodeName, containerId, this.remoteFs, launcher);
            node.setNodeDescription("Docker Agent [" + this.getImage() + " on " + api.getDockerHost().getUri() + " ID " + containerId + "]");
            node.setMode(this.mode);
            node.setLabelString(this.labelString);
            node.setRetentionStrategy(this.retentionStrategy);
            DockerTemplate.robustlySetNodeProperties(node, this.nodeProperties);
            node.setRemoveVolumes(this.removeVolumes);
            node.setDockerAPI(api);
            finallyRemoveTheContainer = false;
            DockerTransientNode dockerTransientNode = node;
            return dockerTransientNode;
        }
        finally {
            if (finallyRemoveTheContainer) {
                try {
                    client.removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).exec();
                }
                catch (NotFoundException ex) {
                    LOGGER.info("Unable to remove container '" + containerId + "' as it had already gone.");
                }
                catch (Throwable ex) {
                    LOGGER.error("Unable to remove container '" + containerId + "' due to exception:", ex);
                }
            }
        }
    }

    private static String calcUnusedNodeName(String templateName) {
        String nodeName;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        do {
            String uniqueId = ID_GENERATOR.getUniqueId();
            nodeName = templateName + '-' + uniqueId;
        } while (jenkins != null && jenkins.getNode(nodeName) != null);
        return nodeName;
    }

    private static void robustlySetNodeProperties(DockerTransientNode node, List<? extends NodeProperty<?>> nodeProperties) throws IOException {
        if (nodeProperties == null || nodeProperties.isEmpty()) {
            return;
        }
        int maxAttempts = 10;
        int attempt = 1;
        while (true) {
            try {
                node.setNodeProperties(nodeProperties);
                return;
            }
            catch (IOException | RuntimeException ex) {
                if (attempt > 10) {
                    throw ex;
                }
                long delayInMilliseconds = 100L * (long)attempt;
                try {
                    Thread.sleep(delayInMilliseconds);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerTemplate template = (DockerTemplate)o;
        if (this.configVersion != template.configVersion) {
            return false;
        }
        if (this.instanceCap != template.instanceCap) {
            return false;
        }
        if (this.removeVolumes != template.removeVolumes) {
            return false;
        }
        if (!this.labelString.equals(template.labelString)) {
            return false;
        }
        if (!((Object)((Object)this.connector)).equals((Object)template.connector)) {
            return false;
        }
        if (!this.remoteFs.equals(template.remoteFs)) {
            return false;
        }
        if (this.mode != template.mode) {
            return false;
        }
        if (!this.retentionStrategy.equals(template.retentionStrategy)) {
            return false;
        }
        if (!this.dockerTemplateBase.equals(template.dockerTemplateBase)) {
            return false;
        }
        if (!this.pullStrategy.equals((Object)template.pullStrategy)) {
            return false;
        }
        if (!this.nodeProperties.equals(template.nodeProperties)) {
            return false;
        }
        if (!this.getDisabled().equals(template.getDisabled())) {
            return false;
        }
        return this.dockerTemplateBase.equals(template.dockerTemplateBase);
    }

    public int hashCode() {
        int result = this.configVersion;
        result = 31 * result + this.labelString.hashCode();
        result = 31 * result + ((Object)((Object)this.connector)).hashCode();
        result = 31 * result + this.remoteFs.hashCode();
        result = 31 * result + this.instanceCap;
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + this.retentionStrategy.hashCode();
        result = 31 * result + this.dockerTemplateBase.hashCode();
        result = 31 * result + (this.removeVolumes ? 1 : 0);
        result = 31 * result + this.labelSet.hashCode();
        result = 31 * result + this.pullStrategy.hashCode();
        result = 31 * result + this.nodeProperties.hashCode();
        result = 31 * result + this.getDisabled().hashCode();
        return result;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerTemplate> {
        public List<NodePropertyDescriptor> getNodePropertiesDescriptors() {
            ArrayList<NodePropertyDescriptor> result = new ArrayList<NodePropertyDescriptor>();
            DescriptorExtensionList list = Jenkins.getInstance().getDescriptorList(NodeProperty.class);
            for (NodePropertyDescriptor npd : DescriptorVisibilityFilter.applyType(DockerTransientNode.class, (Iterable)list)) {
                if (!npd.isApplicable(DockerTransientNode.class)) continue;
                result.add(npd);
            }
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                NodePropertyDescriptor de = (NodePropertyDescriptor)iterator.next();
                if (!"org.jenkinsci.plugins.matrixauth.AuthorizationMatrixNodeProperty".equals(de.getKlass().toJavaClass().getName())) continue;
                iterator.remove();
            }
            return result;
        }

        public Descriptor getRetentionStrategyDescriptor() {
            return Jenkins.getInstance().getDescriptor(DockerOnceRetentionStrategy.class);
        }

        public FormValidation doCheckPullTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public String getDisplayName() {
            return "Docker Template";
        }

        public Class getDockerTemplateBase() {
            return DockerTemplateBase.class;
        }
    }
}

