/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerManagementServer;
import com.nirima.jenkins.plugins.docker.Messages;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerProxy;

@Extension
public class DockerManagement
extends ManagementLink
implements StaplerProxy,
Describable<DockerManagement>,
Saveable {
    public String getIconFileName() {
        return "/plugin/docker-plugin/images//48x48/docker.png";
    }

    public String getUrlName() {
        return "docker-plugin";
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getDescription() {
        return Messages.PluginDescription();
    }

    public static DockerManagement get() {
        return (DockerManagement)((Object)ManagementLink.all().get(DockerManagement.class));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public void save() throws IOException {
    }

    public DockerManagementServer getServer(String serverName) {
        return new DockerManagementServer(serverName);
    }

    public Object getTarget() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    public Collection<String> getServerNames() {
        return Collections2.transform(JenkinsUtils.getServers(), (Function)new Function<DockerCloud, String>(){

            public String apply(@Nullable DockerCloud input) {
                return input.getDisplayName();
            }
        });
    }

    public Collection<ServerDetail> getServers() {
        return Collections2.transform(JenkinsUtils.getServers(), (Function)new Function<DockerCloud, ServerDetail>(){

            public ServerDetail apply(@Nullable DockerCloud input) {
                return new ServerDetail(input);
            }
        });
    }

    public static class ServerDetail {
        final DockerCloud cloud;

        public ServerDetail(DockerCloud cloud) {
            this.cloud = cloud;
        }

        public String getName() {
            return this.cloud.getDisplayName();
        }

        public String getActiveHosts() {
            try {
                List containers;
                DockerAPI dockerApi = this.cloud.getDockerApi();
                try (DockerClient client = dockerApi.getClient();){
                    containers = (List)client.listContainersCmd().exec();
                }
                return "(" + containers.size() + ")";
            }
            catch (Exception ex) {
                return "Error";
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerManagement> {
        public String getDisplayName() {
            return null;
        }
    }
}

