/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerJobTemplateProperty;
import com.nirima.jenkins.plugins.docker.action.DockerBuildAction;
import com.nirima.jenkins.plugins.docker.utils.LogUtils;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.TaskListener;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.model.OptionalJobProperty;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.Exported;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerJobProperty
extends OptionalJobProperty<AbstractProject<?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DockerJobProperty.class.getName());
    public final String additionalTag;
    private boolean pushOnSuccess;
    private DockerRegistryEndpoint registry;
    public final boolean cleanImages;
    @Deprecated
    private DockerJobTemplateProperty dockerJobTemplate;

    @DataBoundConstructor
    public DockerJobProperty(String additionalTag, boolean cleanImages) {
        this.additionalTag = additionalTag;
        this.cleanImages = cleanImages;
    }

    @Exported
    public String getAdditionalTag() {
        return this.additionalTag;
    }

    @Exported
    public boolean isPushOnSuccess() {
        return this.pushOnSuccess;
    }

    @Exported
    public boolean isCleanImages() {
        return this.cleanImages;
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.registry;
    }

    @DataBoundSetter
    public void setRegistry(DockerRegistryEndpoint registry) {
        this.pushOnSuccess = true;
        this.registry = registry;
    }

    @Exported
    public DockerJobTemplateProperty getDockerJobTemplate() {
        return this.dockerJobTemplate;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Node node = build.getBuiltOn();
        if (!(node instanceof DockerTransientNode)) {
            return true;
        }
        DockerTransientNode dockerNode = (DockerTransientNode)node;
        String containerId = dockerNode.getContainerId();
        DockerAPI dockerAPI = dockerNode.getDockerAPI();
        try (DockerClient client = dockerAPI.getClient();){
            boolean bl = this.perform(build, listener, containerId, dockerAPI, client);
            return bl;
        }
    }

    private boolean perform(AbstractBuild<?, ?> build, final BuildListener listener, String containerId, DockerAPI dockerAPI, DockerClient client) throws IOException {
        String tag_image;
        block5: {
            String dockerHost = dockerAPI.getDockerHost().getUri();
            tag_image = client.commitCmd(containerId).withRepository(((AbstractProject)build.getParent()).getDisplayName()).withTag(build.getDisplayName().replace("#", "b")).withAuthor("Jenkins").withMessage(build.getFullDisplayName()).exec();
            this.addJenkinsAction(build, dockerHost, containerId, tag_image);
            try {
                String tagToken = this.getAdditionalTag(build, (TaskListener)listener);
                if (Strings.isNullOrEmpty((String)tagToken)) break block5;
                NameParser.ReposTag reposTag = NameParser.parseRepositoryTag((String)tagToken);
                String commitTag = StringUtils.isEmpty((String)reposTag.tag) ? "latest" : reposTag.tag;
                client.tagImageCmd(tag_image, reposTag.repos, commitTag).withForce().exec();
                this.addJenkinsAction(build, dockerHost, containerId, tagToken);
                if (!this.pushOnSuccess) break block5;
                Identifier identifier = Identifier.fromCompoundString((String)tagToken);
                PushImageResultCallback resultCallback = new PushImageResultCallback(){

                    public void onNext(PushResponseItem item) {
                        LogUtils.printResponseItemToListener((TaskListener)listener, (ResponseItem)item);
                        super.onNext(item);
                    }
                };
                try {
                    PushImageCmd cmd = client.pushImageCmd(identifier);
                    DockerCloud.setRegistryAuthentication(cmd, this.registry, (ItemGroup)Jenkins.getInstance());
                    ((PushImageResultCallback)cmd.exec((ResultCallback)resultCallback)).awaitSuccess();
                }
                catch (DockerException ex) {
                    LOGGER.error("Exception pushing docker image. Check that the destination registry is building.", (Throwable)ex);
                    throw ex;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Could not add additional tags", (Throwable)ex);
            }
        }
        if (this.cleanImages) {
            client.removeImageCmd(tag_image).withForce(Boolean.valueOf(true)).exec();
        }
        return true;
    }

    private String getAdditionalTag(AbstractBuild build, TaskListener listener) {
        String tagToken = this.additionalTag;
        try {
            if (!Strings.isNullOrEmpty((String)tagToken)) {
                tagToken = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)tagToken);
            }
        }
        catch (Exception e) {
            LOGGER.warn("can't expand macro", (Throwable)e);
        }
        return tagToken;
    }

    private void addJenkinsAction(AbstractBuild build, String dockerHost, String containerId, String tag_image) throws IOException {
        build.addAction((Action)new DockerBuildAction(dockerHost, containerId, tag_image));
        build.save();
    }

    private Object readResolve() {
        if (this.pushOnSuccess && this.registry == null) {
            this.registry = new DockerRegistryEndpoint(null, null);
        }
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends OptionalJobProperty.OptionalJobPropertyDescriptor {
        public String getDisplayName() {
            return "Commit agent's Docker container";
        }
    }
}

