/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.model.Container;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ContainerNodeNameMap {
    private final Map<String, String> containerIdNodeNameMap = new HashMap<String, String>();
    private final Set<Container> containerSet = new HashSet<Container>();
    private boolean containerListIncomplete;

    ContainerNodeNameMap() {
    }

    public void registerMapping(Container container, String nodeName) {
        this.containerIdNodeNameMap.put(container.getId(), nodeName);
        this.containerSet.add(container);
    }

    public String getNodeName(String containerId) {
        return this.containerIdNodeNameMap.get(containerId);
    }

    public boolean isContainerIdRegistered(String containerId) {
        return this.containerIdNodeNameMap.containsKey(containerId);
    }

    public Collection<Container> getAllContainers() {
        return Collections.unmodifiableSet(this.containerSet);
    }

    public ContainerNodeNameMap merge(ContainerNodeNameMap other) {
        ContainerNodeNameMap result = new ContainerNodeNameMap();
        result.containerIdNodeNameMap.putAll(this.containerIdNodeNameMap);
        result.containerIdNodeNameMap.putAll(other.containerIdNodeNameMap);
        result.containerSet.addAll(this.containerSet);
        result.containerSet.addAll(other.containerSet);
        return result;
    }

    public boolean isContainerListIncomplete() {
        return this.containerListIncomplete;
    }

    public void setContainerListIncomplete(boolean containerListIncomplete) {
        this.containerListIncomplete = containerListIncomplete;
    }
}

