/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.misc;

import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profile.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.misc.Extension;
import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.misc.ConfiguredWithReadme;
import io.jenkins.plugins.casc.misc.JenkinsConfiguredRule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.core.StringContains;

public class JenkinsConfiguredWithReadmeRule
extends JenkinsConfiguredRule {
    static final DataHolder OPTIONS = PegdownOptionsAdapter.flexmarkOptions((int)65535, (Extension[])new Extension[0]);
    static final Parser PARSER = Parser.builder((DataHolder)OPTIONS).build();

    public void before() throws Throwable {
        block4: {
            super.before();
            ConfiguredWithReadme configuredWithReadme = this.getConfiguredWithReadme();
            if (Objects.nonNull(configuredWithReadme)) {
                Class clazz = this.env.description().getTestClass();
                String[] resource = configuredWithReadme.value();
                List configs = Arrays.stream(resource).map(s -> {
                    try {
                        String currentResource = s.replaceAll("#.*", "");
                        int position = this.getFencedCodeBlockIndex((String)s);
                        File codeBlockFile = File.createTempFile("integrations", "markdown");
                        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(currentResource);
                        List<String> lines = Collections.singletonList(this.transformFencedCodeBlockFromMarkdownToString(inputStream).get(position));
                        Path file = Paths.get(codeBlockFile.getCanonicalPath(), new String[0]);
                        Files.write(file, lines, StandardCharsets.UTF_8, new OpenOption[0]);
                        return codeBlockFile.toURI().toString();
                    }
                    catch (IOException e) {
                        throw new AssertionError("Exception when accessing the resources: " + s, e);
                    }
                }).collect(Collectors.toList());
                try {
                    ConfigurationAsCode.get().configure(configs);
                }
                catch (Throwable t) {
                    boolean match;
                    if (!configuredWithReadme.expected().isInstance(t)) {
                        throw new AssertionError("Unexpected exception ", t);
                    }
                    if (StringUtils.isBlank((String)configuredWithReadme.message()) || (match = new StringContains(false, configuredWithReadme.message()).matches((Object)t.getMessage()))) break block4;
                    throw new AssertionError((Object)("Exception did not contain the expected string: " + configuredWithReadme.message() + "\nMessage was:\n" + t.getMessage()));
                }
            }
        }
    }

    private ConfiguredWithReadme getConfiguredWithReadme() {
        ConfiguredWithReadme configuredWithReadme = (ConfiguredWithReadme)this.env.description().getAnnotation(ConfiguredWithReadme.class);
        if (Objects.nonNull(configuredWithReadme)) {
            return configuredWithReadme;
        }
        for (Field field : this.env.description().getTestClass().getFields()) {
            if (!field.isAnnotationPresent(ConfiguredWithReadme.class)) continue;
            int m = field.getModifiers();
            Class<JenkinsConfiguredWithReadmeRule> clazz = field.getType();
            if (Modifier.isPublic(m) && Modifier.isStatic(m) && clazz.isAssignableFrom(JenkinsConfiguredWithReadmeRule.class)) {
                configuredWithReadme = field.getAnnotation(ConfiguredWithReadme.class);
                if (!Objects.nonNull(configuredWithReadme)) continue;
                return configuredWithReadme;
            }
            throw new IllegalStateException("Field must be public static JenkinsConfiguredWithReadmeRule");
        }
        return null;
    }

    private List<String> transformFencedCodeBlockFromMarkdownToString(InputStream markdownContent) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        MutableDataSet FORMAT_OPTIONS = new MutableDataSet();
        FORMAT_OPTIONS.set(Parser.EXTENSIONS, (Object)((Collection)OPTIONS.get(Parser.EXTENSIONS)));
        InputStreamReader targetReader = new InputStreamReader(markdownContent);
        Document document = PARSER.parseReader((Reader)targetReader);
        TextCollectingVisitor textCollectingVisitor = new TextCollectingVisitor(new Class[0]);
        for (Node fencedCodeBlock = document.getChildOfType(new Class[]{FencedCodeBlock.class}); fencedCodeBlock != null; fencedCodeBlock = fencedCodeBlock.getNextAny(new Class[]{FencedCodeBlock.class})) {
            results.add(textCollectingVisitor.collectAndGetText(fencedCodeBlock));
        }
        return results;
    }

    private int getFencedCodeBlockIndex(String resource) {
        int position = 0;
        if (resource.matches(".*#\\d+$")) {
            position = Integer.parseInt(resource.replaceAll(".*#", ""));
        }
        return position;
    }
}

