/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.misc;

import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.misc.ConfiguredWithCode;
import io.jenkins.plugins.casc.misc.JenkinsConfiguredRule;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.core.StringContains;

public class JenkinsConfiguredWithCodeRule
extends JenkinsConfiguredRule {
    public void before() throws Throwable {
        block4: {
            super.before();
            ConfiguredWithCode configuredWithCode = this.getConfiguredWithCode();
            if (Objects.nonNull(configuredWithCode)) {
                Class clazz = this.env.description().getTestClass();
                String[] resource = configuredWithCode.value();
                List configs = Arrays.stream(resource).map(s -> {
                    URL config = clazz.getResource((String)s);
                    if (config == null) {
                        config = clazz.getClassLoader().getResource((String)s);
                    }
                    if (config != null) {
                        return config.toExternalForm();
                    }
                    throw new AssertionError((Object)("Exception when accessing the resources: " + s));
                }).collect(Collectors.toList());
                try {
                    ConfigurationAsCode.get().configure(configs);
                }
                catch (Throwable t) {
                    boolean match;
                    if (!configuredWithCode.expected().isInstance(t)) {
                        throw new AssertionError("Unexpected exception ", t);
                    }
                    if (StringUtils.isBlank((String)configuredWithCode.message()) || (match = new StringContains(false, configuredWithCode.message()).matches((Object)t.getMessage()))) break block4;
                    throw new AssertionError((Object)("Exception did not contain the expected string: " + configuredWithCode.message() + "\nMessage was:\n" + t.getMessage()));
                }
            }
        }
    }

    private ConfiguredWithCode getConfiguredWithCode() {
        ConfiguredWithCode configuredWithCode = (ConfiguredWithCode)this.env.description().getAnnotation(ConfiguredWithCode.class);
        if (Objects.nonNull(configuredWithCode)) {
            return configuredWithCode;
        }
        for (Field field : this.env.description().getTestClass().getFields()) {
            if (!field.isAnnotationPresent(ConfiguredWithCode.class)) continue;
            int m = field.getModifiers();
            Class<JenkinsConfiguredWithCodeRule> clazz = field.getType();
            if (Modifier.isPublic(m) && Modifier.isStatic(m) && clazz.isAssignableFrom(JenkinsConfiguredWithCodeRule.class)) {
                configuredWithCode = field.getAnnotation(ConfiguredWithCode.class);
                if (!Objects.nonNull(configuredWithCode)) continue;
                return configuredWithCode;
            }
            throw new IllegalStateException("Field must be public static JenkinsConfiguredWithCodeRule");
        }
        return null;
    }
}

