/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.ConfiguratorRegistry;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.SecretSource;
import io.jenkins.plugins.casc.SecretSourceResolver;
import io.jenkins.plugins.casc.VersionConverter;
import io.jenkins.plugins.casc.model.CNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.math.NumberUtils;
import org.kohsuke.stapler.Stapler;

public class ConfigurationContext
implements ConfiguratorRegistry {
    public static final String CASC_YAML_MAX_ALIASES_ENV = "CASC_YAML_MAX_ALIASES";
    public static final String CASC_YAML_MAX_ALIASES_PROPERTY = "casc.yaml.max.aliases";
    public static final String CASC_YAML_CODE_POINT_LIMIT_ENV = "CASC_YAML_CODE_POINT_LIMIT";
    public static final String CASC_YAML_CODE_POINT_LIMIT_PROPERTY = "casc.yaml.code_point_limit";
    public static final String CASC_MERGE_STRATEGY_ENV = "CASC_MERGE_STRATEGY";
    public static final String CASC_MERGE_STRATEGY_PROPERTY = "casc.merge.strategy";
    private Deprecation deprecation = Deprecation.reject;
    private Restriction restriction = Restriction.reject;
    private Unknown unknown = Unknown.reject;
    private String mergeStrategy;
    private final transient int yamlMaxAliasesForCollections;
    private final transient int yamlCodePointLimit;
    private Version version = Version.ONE;
    private transient List<Listener> listeners = new ArrayList<Listener>();
    private final transient ConfiguratorRegistry registry;
    private transient String mode;
    private transient SecretSourceResolver secretSourceResolver;

    public ConfigurationContext(ConfiguratorRegistry registry) {
        this(registry, null);
    }

    public ConfigurationContext(ConfiguratorRegistry registry, String mergeStrategy) {
        this.registry = registry;
        String prop = this.getPropertyOrEnv(CASC_YAML_MAX_ALIASES_ENV, CASC_YAML_MAX_ALIASES_PROPERTY);
        this.yamlMaxAliasesForCollections = NumberUtils.toInt((String)prop, (int)50);
        prop = this.getPropertyOrEnv(CASC_YAML_CODE_POINT_LIMIT_ENV, CASC_YAML_CODE_POINT_LIMIT_PROPERTY);
        this.yamlCodePointLimit = NumberUtils.toInt((String)prop, (int)3) * 1024 * 1024;
        this.secretSourceResolver = new SecretSourceResolver(this);
        this.mergeStrategy = mergeStrategy != null ? mergeStrategy : this.getPropertyOrEnv(CASC_MERGE_STRATEGY_ENV, CASC_MERGE_STRATEGY_PROPERTY);
    }

    private String getPropertyOrEnv(String envKey, String proKey) {
        return Util.fixEmptyAndTrim((String)System.getProperty(proKey, System.getenv(envKey)));
    }

    public SecretSourceResolver getSecretSourceResolver() {
        return this.secretSourceResolver;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void warning(@NonNull CNode node, @NonNull String message) {
        for (Listener listener : this.listeners) {
            listener.warning(node, message);
        }
    }

    public Deprecation getDeprecated() {
        return this.deprecation;
    }

    public Restriction getRestricted() {
        return this.restriction;
    }

    public Unknown getUnknown() {
        return this.unknown;
    }

    public void setDeprecated(Deprecation deprecation) {
        this.deprecation = deprecation;
    }

    public void setRestricted(Restriction restriction) {
        this.restriction = restriction;
    }

    public void setUnknown(Unknown unknown) {
        this.unknown = unknown;
    }

    public String getMergeStrategy() {
        return this.mergeStrategy;
    }

    String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public int getYamlMaxAliasesForCollections() {
        return this.yamlMaxAliasesForCollections;
    }

    public int getYamlCodePointLimit() {
        return this.yamlCodePointLimit;
    }

    @Override
    @CheckForNull
    public RootElementConfigurator lookupRootElement(String name) {
        return this.registry.lookupRootElement(name);
    }

    @Override
    @NonNull
    public <T> Configurator<T> lookupOrFail(Type type) throws ConfiguratorException {
        return this.registry.lookupOrFail(type);
    }

    @Override
    @CheckForNull
    public <T> Configurator<T> lookup(Type type) {
        return this.registry.lookup(type);
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public List<SecretSource> getSecretSources() {
        return SecretSource.all();
    }

    static {
        Stapler.CONVERT_UTILS.register((Converter)new VersionConverter(), Version.class);
    }

    static enum Deprecation {
        reject,
        warn;

    }

    static enum Restriction {
        reject,
        beta,
        warn;

    }

    static enum Unknown {
        reject,
        warn;

    }

    static enum Version {
        ONE("1");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        public static Version of(String version) {
            switch (version) {
                case "1": {
                    return ONE;
                }
            }
            throw new IllegalArgumentException("unsupported version " + version);
        }

        public String value() {
            return this.value;
        }

        public boolean isAtLeast(Version version) {
            return this.ordinal() >= version.ordinal();
        }

        public String toString() {
            return this.value;
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void warning(@NonNull CNode var1, @NonNull String var2);
    }
}

