/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.impl.configurators.DescriptorConfigurator;
import io.jenkins.plugins.casc.impl.configurators.GlobalConfigurationCategoryConfigurator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;

public interface RootElementConfigurator<T>
extends Configurator<T> {
    public static List<RootElementConfigurator> all() {
        Jenkins jenkins = Jenkins.get();
        ArrayList<RootElementConfigurator> configurators = new ArrayList<RootElementConfigurator>((Collection<RootElementConfigurator>)jenkins.getExtensionList(RootElementConfigurator.class));
        for (GlobalConfigurationCategory category : GlobalConfigurationCategory.all()) {
            configurators.add(new GlobalConfigurationCategoryConfigurator(category));
        }
        for (ManagementLink link : ManagementLink.all()) {
            String name = link.getUrlName();
            Descriptor descriptor = Jenkins.get().getDescriptor(name);
            if (descriptor == null) continue;
            configurators.add(new DescriptorConfigurator(descriptor));
        }
        configurators.sort(Configurator.extensionOrdinalSort());
        return configurators;
    }

    default public boolean isRootElement() {
        return true;
    }

    public T getTargetComponent(ConfigurationContext var1);
}

