/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.configurators.DataBoundConfigurator;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.ArrayList;
import java.util.List;

@Extension
public class GlobalNodePropertiesConfigurator
extends DataBoundConfigurator<EnvironmentVariablesNodeProperty> {
    public GlobalNodePropertiesConfigurator() {
        this(EnvironmentVariablesNodeProperty.class);
    }

    public GlobalNodePropertiesConfigurator(Class<?> clazz) {
        super(EnvironmentVariablesNodeProperty.class);
    }

    @Override
    @NonNull
    public String getName() {
        return "globalNodeProperties";
    }

    @Override
    @NonNull
    public EnvironmentVariablesNodeProperty configure(CNode c, ConfigurationContext context) throws ConfiguratorException {
        Mapping mapping = c.asMapping();
        List<EnvironmentVariablesNodeProperty.Entry> variables = this.getVarsAsList(mapping);
        return new EnvironmentVariablesNodeProperty(variables);
    }

    private List<EnvironmentVariablesNodeProperty.Entry> getVarsAsList(Mapping m) {
        List<EnvironmentVariablesNodeProperty.Entry> result = new ArrayList<EnvironmentVariablesNodeProperty.Entry>();
        if (m.get("env") != null) {
            result = ((CNode)m.get("env")).asSequence().stream().map(pair -> {
                if (pair.asMapping().get("key") == null) {
                    return null;
                }
                String key = ((CNode)pair.asMapping().get("key")).asScalar().getValue();
                String value = pair.asMapping().get("value") == null ? "" : ((CNode)pair.asMapping().get("value")).asScalar().getValue();
                return new EnvironmentVariablesNodeProperty.Entry(key, value);
            }).toList();
        }
        return result;
    }
}

