/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.model;

import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Scalar;
import io.jenkins.plugins.casc.model.Sequence;
import io.jenkins.plugins.casc.model.Source;
import java.util.HashMap;

public final class Mapping
extends HashMap<String, CNode>
implements CNode {
    public static final Mapping EMPTY = new Mapping();
    private Source source;

    public Mapping() {
    }

    public Mapping(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public CNode.Type getType() {
        return CNode.Type.MAPPING;
    }

    @Override
    public Mapping asMapping() {
        return this;
    }

    @Override
    public void put(String key, String value) {
        super.put(key, new Scalar(value));
    }

    @Override
    public void put(String key, Number value) {
        super.put(key, new Scalar(String.valueOf(value)));
    }

    @Override
    public void put(String key, Boolean value) {
        super.put(key, new Scalar(String.valueOf(value)));
    }

    public void putIfNotNull(String key, CNode node) {
        if (node != null) {
            super.put(key, node);
        }
    }

    public void putIfNotEmpty(String key, Sequence seq) {
        if (!seq.isEmpty()) {
            super.put(key, seq);
        }
    }

    public String getScalarValue(String key) throws ConfiguratorException {
        return ((CNode)this.remove(key)).asScalar().getValue();
    }

    public void setSource(Source source) {
        this.source = source;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public Mapping clone() {
        Mapping clone = new Mapping();
        this.forEach((key, value) -> {
            if (value != null) {
                clone.put(key, value.clone());
            }
        });
        return clone;
    }
}

