/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.secrets;

import hudson.Extension;
import io.jenkins.plugins.casc.SecretSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class PropertiesSecretSource
extends SecretSource {
    private static final Logger LOGGER = Logger.getLogger(PropertiesSecretSource.class.getName());
    public static final String SECRETS_DEFAULT_PATH = "/run/secrets/secrets.properties";
    private final Properties secrets = new Properties();

    @Override
    public Optional<String> reveal(String secret) {
        return Optional.ofNullable(this.secrets.getProperty(secret));
    }

    @Override
    public void init() {
        String secretsEnv = System.getenv("SECRETS_FILE");
        String secretsPath = secretsEnv == null ? SECRETS_DEFAULT_PATH : secretsEnv;
        File secretsFile = new File(secretsPath);
        if (secretsFile.exists() && secretsFile.isFile()) {
            try (FileInputStream input = new FileInputStream(secretsFile);){
                this.secrets.clear();
                this.secrets.load(input);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Source properties file " + secretsPath + " could not be loaded", ioe);
            }
        }
    }
}

