/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.yaml;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.jenkinsci.plugins.casc.model.Scalar;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.jenkinsci.plugins.casc.model.Source;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ModelConstructor
extends Constructor {
    private static final Construct ConstructScalar = new AbstractConstruct(){

        public Object construct(Node node) {
            String value = ((ScalarNode)node).getValue();
            return new Scalar(value, ModelConstructor.getSource(node));
        }
    };

    public ModelConstructor() {
        super(Mapping.class);
        this.yamlConstructors.put(Tag.BOOL, ConstructScalar);
        this.yamlConstructors.put(Tag.INT, ConstructScalar);
    }

    private static Source getSource(Node node) {
        Mark mark = node.getStartMark();
        return new Source(mark.getName(), mark.getLine() + 1);
    }

    protected Object constructScalar(ScalarNode node) {
        return new Scalar(node.getValue());
    }

    protected Map createDefaultMap() {
        return new Mapping();
    }

    protected void constructMapping2ndStep(MappingNode node, final Map mapping) {
        ((Mapping)mapping).setSource(ModelConstructor.getSource((Node)node));
        super.constructMapping2ndStep(node, (Map)new AbstractMapDecorator(mapping){

            public Object put(Object key, Object value) {
                if (!(key instanceof Scalar)) {
                    throw new IllegalStateException("We only support scalar map keys");
                }
                if (value instanceof Number) {
                    value = new Scalar(value.toString());
                } else if (value instanceof Boolean) {
                    value = new Scalar(value.toString());
                }
                return mapping.put(key.toString(), value);
            }
        });
    }

    protected List createDefaultList(int initSize) {
        return new Sequence(initSize);
    }

    protected void constructSequenceStep2(SequenceNode node, Collection collection) {
        ((Sequence)collection).setSource(ModelConstructor.getSource((Node)node));
        super.constructSequenceStep2(node, collection);
    }
}

