/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.ExtensionList;
import hudson.model.Descriptor;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.DescriptorConfigurator;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.model.CNode;

public class GlobalConfigurationCategoryConfigurator
extends BaseConfigurator<GlobalConfigurationCategory>
implements RootElementConfigurator<GlobalConfigurationCategory> {
    private final GlobalConfigurationCategory category;

    public GlobalConfigurationCategoryConfigurator(GlobalConfigurationCategory category) {
        this.category = category;
    }

    @Override
    public String getName() {
        Class<?> c = this.category.getClass();
        Symbol symbol = c.getAnnotation(Symbol.class);
        if (symbol != null) {
            return symbol.value()[0];
        }
        String name = c.getSimpleName();
        name = StringUtils.remove((String)name, (String)"Global");
        name = StringUtils.remove((String)name, (String)"Configuration");
        name = StringUtils.remove((String)name, (String)"Category");
        return name;
    }

    @Override
    public Class getTarget() {
        return this.category.getClass();
    }

    @Override
    public GlobalConfigurationCategory getTargetComponent() {
        return this.category;
    }

    @Override
    public GlobalConfigurationCategory configure(CNode config) throws ConfiguratorException {
        this.configure(config.asMapping(), this.category);
        return this.category;
    }

    @Override
    public Set<Attribute> describe() {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        ExtensionList descriptors = Jenkins.getInstance().getExtensionList(Descriptor.class);
        for (Descriptor descriptor : descriptors) {
            if (descriptor.getCategory() != this.category || descriptor.getGlobalConfigPage() == null) continue;
            DescriptorConfigurator configurator = new DescriptorConfigurator(descriptor);
            attributes.add(new Attribute(configurator.getName(), configurator.getTarget()){

                public void setValue(Object target, Object value) throws Exception {
                }
            });
        }
        return attributes;
    }

    @Override
    @CheckForNull
    public CNode describe(GlobalConfigurationCategory instance) {
        return null;
    }
}

