/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.plugins;

import hudson.Extension;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.model.DownloadService;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.MultivaluedAttribute;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.jenkinsci.plugins.casc.plugins.PluginToInstall;
import org.jenkinsci.plugins.casc.plugins.Plugins;

@Extension(ordinal=999.0)
public class PluginManagerConfigurator
extends BaseConfigurator<PluginManager>
implements RootElementConfigurator<PluginManager> {
    private static final Logger logger = Logger.getLogger(PluginManagerConfigurator.class.getName());

    @Override
    public Class<PluginManager> getTarget() {
        return PluginManager.class;
    }

    @Override
    public PluginManager getTargetComponent() {
        return Jenkins.getInstance().getPluginManager();
    }

    @Override
    public PluginManager configure(CNode config) throws ConfiguratorException {
        Mapping map = config.asMapping();
        Jenkins jenkins = Jenkins.getInstance();
        CNode proxy = (CNode)map.get("proxy");
        if (proxy != null) {
            ProxyConfiguration pcc;
            Configurator pc = Configurator.lookup(ProxyConfiguration.class);
            if (pc == null) {
                throw new ConfiguratorException("ProxyConfiguration not well registered");
            }
            jenkins.proxy = pcc = (ProxyConfiguration)pc.configure(proxy);
        }
        CNode sites = (CNode)map.get("sites");
        UpdateCenter updateCenter = jenkins.getUpdateCenter();
        if (sites != null) {
            Configurator usc = Configurator.lookup(UpdateSite.class);
            ArrayList<UpdateSite> updateSites = new ArrayList<UpdateSite>();
            for (CNode data : sites.asSequence()) {
                UpdateSite in = (UpdateSite)usc.configure(data);
                if (in.isDue()) {
                    in.updateDirectly(DownloadService.signatureCheck);
                }
                updateSites.add(in);
            }
            try {
                updateCenter.getSites().replaceBy(updateSites);
            }
            catch (IOException e) {
                throw new ConfiguratorException("failed to reconfigure updateCenter.sites", e);
            }
        }
        LinkedList<PluginToInstall> plugins = new LinkedList<PluginToInstall>();
        CNode required = (CNode)map.get("required");
        if (required != null) {
            for (Map.Entry entry : required.asMapping().entrySet()) {
                plugins.add(new PluginToInstall((String)entry.getKey(), ((CNode)entry.getValue()).asScalar().getValue()));
            }
        }
        File shrinkwrap = new File(jenkins.getRootDir(), "plugins.txt");
        logger.log(Level.CONFIG, String.format("Using shrinkwrap file: '%s'", shrinkwrap.getAbsoluteFile()));
        HashMap<String, PluginToInstall> shrinkwrapped = new HashMap<String, PluginToInstall>();
        if (shrinkwrap.exists()) {
            try {
                List lines = FileUtils.readLines((File)shrinkwrap, (Charset)StandardCharsets.UTF_8);
                for (String line : lines) {
                    int i = line.indexOf(58);
                    String shortname = line.substring(0, i);
                    shrinkwrapped.put(shortname, new PluginToInstall(shortname, line.substring(i + 1)));
                }
            }
            catch (IOException e) {
                throw new ConfiguratorException("failed to load plugins.txt shrinkwrap file", e);
            }
            boolean outdated = false;
            for (PluginToInstall plugin : plugins) {
                PluginToInstall other = (PluginToInstall)shrinkwrapped.get(plugin.shortname);
                if (other != null && other.equals(plugin)) continue;
                outdated = true;
                break;
            }
            if (!outdated) {
                plugins.addAll(shrinkwrapped.values());
            }
        }
        PluginManager pluginManager = this.getTargetComponent();
        if (!plugins.isEmpty()) {
            logger.log(Level.CONFIG, String.format("Using plugin root dir: '%s'", pluginManager.rootDir));
            boolean requireRestart = false;
            HashSet<String> installed = new HashSet<String>();
            while (!plugins.isEmpty()) {
                Plugin plugin;
                PluginToInstall p = (PluginToInstall)plugins.remove();
                if (installed.contains(p.shortname) || (plugin = jenkins.getPlugin(p.shortname)) != null && plugin.getWrapper().getVersion().equals(p.version)) continue;
                requireRestart |= plugin != null;
                JSONObject json = new JSONObject();
                json.accumulate("name", (Object)p.shortname);
                json.accumulate("version", (Object)p.version);
                json.accumulate("url", (Object)("download/plugins/" + p.shortname + "/" + p.version + "/" + p.shortname + ".hpi"));
                json.accumulate("dependencies", (Object)new JSONArray());
                boolean downloaded = false;
                UpdateSite updateSite = updateCenter.getSite(p.site);
                if (updateSite == null) {
                    throw new ConfiguratorException("Can't install " + p + ": no update site " + p.site);
                }
                UpdateSite updateSite2 = updateSite;
                updateSite2.getClass();
                UpdateSite.Plugin installable = new UpdateSite.Plugin(updateSite2, updateSite.getId(), json);
                try {
                    UpdateCenter.UpdateCenterJob job = (UpdateCenter.UpdateCenterJob)installable.deploy(true).get();
                    if (job.getError() != null) {
                        if (job.getError() instanceof UpdateCenter.DownloadJob.SuccessButRequiresRestart) {
                            requireRestart = true;
                        } else {
                            throw job.getError();
                        }
                    }
                    installed.add(p.shortname);
                    File jpi = new File(pluginManager.rootDir, p.shortname + ".jpi");
                    try (JarFile jar = new JarFile(jpi);){
                        String dependencySpec = jar.getManifest().getMainAttributes().getValue("Plugin-Dependencies");
                        if (dependencySpec != null) {
                            plugins.addAll(Arrays.stream(dependencySpec.split(",")).filter(t -> !t.endsWith(";resolution:=optional")).map(t -> t.substring(0, t.indexOf(58))).map(a -> new PluginToInstall((String)a, "latest")).collect(Collectors.toList()));
                        }
                    }
                    downloaded = true;
                    break;
                }
                catch (InterruptedException | ExecutionException ex) {
                    logger.info("Failed to download plugin " + p.shortname + ':' + p.version + "from update site " + updateSite.getId());
                }
                catch (Throwable ex) {
                    throw new ConfiguratorException("Failed to download plugin " + p.shortname + ':' + p.version, ex);
                }
                if (downloaded) continue;
                throw new ConfiguratorException("Failed to install plugin " + p.shortname + ':' + p.version);
            }
            try (PrintWriter w = new PrintWriter(shrinkwrap, StandardCharsets.UTF_8.name());){
                for (PluginWrapper pw : pluginManager.getPlugins()) {
                    if (pw.getShortName().equals("configuration-as-code")) continue;
                    String from = "default";
                    for (UpdateSite site : jenkins.getUpdateCenter().getSites()) {
                        if (site.getPlugin(pw.getShortName()) == null) continue;
                        from = site.getId();
                        break;
                    }
                    w.println(pw.getShortName() + ':' + pw.getVersionNumber().toString() + '@' + from);
                }
            }
            catch (IOException e) {
                throw new ConfiguratorException("failed to write plugins.txt shrinkwrap file", e);
            }
            if (requireRestart) {
                try {
                    jenkins.restart();
                }
                catch (RestartNotSupportedException e) {
                    throw new ConfiguratorException("Can't restart master after plugins installation", e);
                }
            }
        }
        try {
            jenkins.save();
        }
        catch (IOException e) {
            throw new ConfiguratorException("failed to save Jenkins configuration", e);
        }
        return pluginManager;
    }

    @Override
    public String getName() {
        return "plugins";
    }

    @Override
    public Set<Attribute> describe() {
        HashSet<Attribute> attr = new HashSet<Attribute>();
        attr.add(new Attribute("proxy", ProxyConfiguration.class));
        attr.add(new MultivaluedAttribute("sites", UpdateSite.class));
        attr.add(new MultivaluedAttribute("required", Plugins.class));
        return attr;
    }

    @Override
    @CheckForNull
    public CNode describe(PluginManager instance) throws Exception {
        Mapping mapping = new Mapping();
        Configurator cp = Configurator.lookupOrFail(ProxyConfiguration.class);
        mapping.putIfNotNull("proxy", cp.describe(Jenkins.getInstance().proxy));
        Sequence seq = new Sequence();
        Configurator cs = Configurator.lookupOrFail(UpdateSite.class);
        for (UpdateSite site : Jenkins.getInstance().getUpdateCenter().getSiteList()) {
            seq.add(cs.describe(site));
        }
        mapping.putIfNotEmpry("sites", seq);
        return mapping;
    }
}

