/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.integrations.projectmatriaxauth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.security.Permission;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.ConfigurationContext;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.integrations.globalmatrixauth.GroupPermissionDefinition;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true)
@Restricted(value={NoExternalUse.class})
public class ProjectMatrixAuthorizationStrategyConfigurator
extends Configurator<ProjectMatrixAuthorizationStrategy> {
    @Override
    public String getName() {
        return "projectMatrix";
    }

    @Override
    public Class<ProjectMatrixAuthorizationStrategy> getTarget() {
        return ProjectMatrixAuthorizationStrategy.class;
    }

    @Override
    public ProjectMatrixAuthorizationStrategy configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        Mapping map = config.asMapping();
        Sequence o = ((CNode)map.get("grantedPermissions")).asSequence();
        Configurator permissionConfigurator = Configurator.lookupOrFail(GroupPermissionDefinition.class);
        HashMap<Permission, Set<String>> grantedPermissions = new HashMap<Permission, Set<String>>();
        for (CNode entry : o) {
            GroupPermissionDefinition gpd = (GroupPermissionDefinition)permissionConfigurator.configure(entry, context);
            gpd.grantPermission(grantedPermissions);
        }
        ProjectMatrixAuthorizationStrategy gms = new ProjectMatrixAuthorizationStrategy();
        for (Map.Entry permission : grantedPermissions.entrySet()) {
            for (String sid : (Set)permission.getValue()) {
                gms.add((Permission)permission.getKey(), sid);
            }
        }
        return gms;
    }

    @Override
    public ProjectMatrixAuthorizationStrategy check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"DM_NEW_FOR_GETCLASS"}, justification="We need a fully qualified type to do proper attribute binding")
    public Set<Attribute> describe() {
        return Collections.singleton(new Attribute("grantedPermissions", new HashSet().getClass()));
    }

    @Override
    @CheckForNull
    public CNode describe(ProjectMatrixAuthorizationStrategy instance) {
        return null;
    }
}

