/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.integrations.globalmatrixauth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.ConfigurationContext;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.integrations.globalmatrixauth.GroupPermissionDefinition;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true)
@Restricted(value={NoExternalUse.class})
public class GlobalMatrixAuthorizationStrategyConfigurator
extends Configurator<GlobalMatrixAuthorizationStrategy> {
    @Override
    public String getName() {
        return "globalMatrix";
    }

    @Override
    public Class<GlobalMatrixAuthorizationStrategy> getTarget() {
        return GlobalMatrixAuthorizationStrategy.class;
    }

    @Override
    @SuppressFBWarnings(value={"DM_NEW_FOR_GETCLASS"}, justification="We need a fully qualified type to do proper attribute binding")
    public Set<Attribute> describe() {
        return Collections.singleton(new Attribute("grantedPermissions", new HashSet().getClass()));
    }

    @Override
    public GlobalMatrixAuthorizationStrategy configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        Mapping map = config.asMapping();
        Configurator permissionConfigurator = Configurator.lookupOrFail(GroupPermissionDefinition.class);
        HashMap<Permission, Set<String>> grantedPermissions = new HashMap<Permission, Set<String>>();
        for (CNode entry : ((CNode)map.get("grantedPermissions")).asSequence()) {
            GroupPermissionDefinition gpd = (GroupPermissionDefinition)permissionConfigurator.configure(entry, context);
            gpd.grantPermission(grantedPermissions);
        }
        GlobalMatrixAuthorizationStrategy gms = new GlobalMatrixAuthorizationStrategy();
        try {
            Field f = gms.getClass().getDeclaredField("grantedPermissions");
            f.setAccessible(true);
            f.set(gms, grantedPermissions);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new ConfiguratorException(this, "Cannot set GlobalMatrixAuthorizationStrategy#grantedPermissions via reflection", ex);
        }
        return gms;
    }

    @Override
    public GlobalMatrixAuthorizationStrategy check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return null;
    }

    @Override
    @CheckForNull
    public CNode describe(GlobalMatrixAuthorizationStrategy instance) {
        return null;
    }
}

