/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.impl.configurators;

import com.google.common.base.Defaults;
import hudson.model.Descriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.ConfigurationContext;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.impl.attributes.DescribableAttribute;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.Stapler;

@Restricted(value={Beta.class})
public class DataBoundConfigurator<T>
extends BaseConfigurator<T> {
    private static final Logger logger = Logger.getLogger(DataBoundConfigurator.class.getName());
    private final Class<T> target;

    public DataBoundConfigurator(Class<T> clazz) {
        this.target = clazz;
    }

    @Override
    public Class getTarget() {
        return this.target;
    }

    @Override
    protected T instance(Mapping config, ConfigurationContext context) throws ConfiguratorException {
        Constructor dataBoundConstructor = this.getDataBoundConstructor();
        return this.tryConstructor(dataBoundConstructor, config, context);
    }

    @Override
    @Nonnull
    public T configure(CNode c, ConfigurationContext context) throws ConfiguratorException {
        Object object = super.configure(c, context);
        for (Method method : this.target.getMethods()) {
            if (method.getParameterCount() != 0 || method.getAnnotation(PostConstruct.class) == null) continue;
            try {
                method.invoke(object, null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfiguratorException(this, "Failed to invoke configurator method " + method, e);
            }
        }
        return object;
    }

    @Override
    public T check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return super.configure(config, context);
    }

    private T tryConstructor(Constructor<T> constructor, Mapping config, ConfigurationContext context) throws ConfiguratorException {
        T object;
        Parameter[] parameters = constructor.getParameters();
        String[] names = ClassDescriptor.loadParameterNames(constructor);
        Object[] args = new Object[names.length];
        if (parameters.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                CNode value = (CNode)config.get(names[i]);
                if (value == null && parameters[i].getAnnotation(Nonnull.class) != null) {
                    throw new ConfiguratorException(names[i] + " is required to configure " + this.target);
                }
                Class<?> t = parameters[i].getType();
                if (value != null) {
                    Type pt;
                    if (Collection.class.isAssignableFrom(t)) {
                        pt = parameters[i].getParameterizedType();
                        Configurator lookup = Configurator.lookupOrFail(pt);
                        ArrayList list = new ArrayList();
                        for (CNode o : value.asSequence()) {
                            list.add(lookup.configure(o, context));
                        }
                        args[i] = list;
                    } else {
                        pt = parameters[i].getParameterizedType();
                        Class<?> k = pt != null ? pt : t;
                        Configurator configurator = Configurator.lookupOrFail(k);
                        args[i] = configurator.configure(value, context);
                    }
                    logger.info("Setting " + this.target + "." + names[i] + " = " + (value.isSensitiveData() ? "****" : value));
                    continue;
                }
                if (!t.isPrimitive()) continue;
                args[i] = Defaults.defaultValue(t);
            }
        }
        try {
            object = constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            ArrayList<String> argumentTypes = new ArrayList<String>(args.length);
            for (Object arg : args) {
                argumentTypes.add(arg != null ? arg.getClass().getName() : "null");
            }
            throw new ConfiguratorException(this, "Failed to construct instance of " + this.target + ".\n Constructor: " + constructor.toString() + ".\n Arguments: " + argumentTypes, ex);
        }
        for (int i = 0; i < names.length; ++i) {
            config.remove(names[i]);
        }
        return object;
    }

    @Override
    public String getName() {
        Descriptor d = this.getDescriptor();
        return DescribableAttribute.getPreferredSymbol(d, this.getExtensionPoint(), this.getTarget());
    }

    private Descriptor getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getTarget());
    }

    @Override
    public Class getExtensionPoint() {
        Descriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            Type superclass;
            Class<?> c = descriptor.getClass();
            do {
                superclass = c.getGenericSuperclass();
            } while ((c = c.getSuperclass()) != Descriptor.class);
            if (superclass instanceof ParameterizedType) {
                ParameterizedType genericSuperclass = (ParameterizedType)superclass;
                Type type = genericSuperclass.getActualTypeArguments()[0];
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                if (type instanceof Class) {
                    return (Class)type;
                }
            }
        }
        return super.getExtensionPoint();
    }

    @Override
    public Set<Attribute> describe() {
        Set<Attribute> attributes = super.describe();
        Constructor constructor = DataBoundConfigurator.getDataBoundConstructor(this.target);
        if (constructor != null) {
            Parameter[] parameters = constructor.getParameters();
            String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
            for (int i = 0; i < parameters.length; ++i) {
                Parameter p = parameters[i];
                Attribute a = this.detectActualType(names[i], BaseConfigurator.TypePair.of(p));
                if (a == null) continue;
                attributes.add(a);
            }
        }
        return attributes;
    }

    @Override
    @CheckForNull
    public CNode describe(T instance) throws Exception {
        Constructor constructor = this.getDataBoundConstructor();
        Parameter[] parameters = constructor.getParameters();
        String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
        Attribute[] attributes = new Attribute[parameters.length];
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            Attribute a = this.detectActualType(names[i], BaseConfigurator.TypePair.of(p));
            args[i] = Stapler.CONVERT_UTILS.convert(a.getValue(instance), a.getType());
            if (args[i] == null && p.getType().isPrimitive()) {
                args[i] = Defaults.defaultValue(p.getType());
            }
            attributes[i] = a;
        }
        Object ref = constructor.newInstance(args);
        Mapping mapping = this.compare(instance, ref);
        for (int i = 0; i < parameters.length; ++i) {
            Configurator c = Configurator.lookup(attributes[i].getType());
            if (args[i] == null) continue;
            mapping.put(names[i], attributes[i].describe(instance));
        }
        return mapping.isEmpty() ? null : mapping;
    }

    private Constructor getDataBoundConstructor() throws ConfiguratorException {
        Constructor constructor = DataBoundConfigurator.getDataBoundConstructor(this.target);
        if (constructor == null) {
            throw new ConfiguratorException(this.target.getName() + " is missing a @DataBoundConstructor");
        }
        return constructor;
    }

    @Override
    public String getDisplayName() {
        Descriptor descriptor = this.getDescriptor();
        return descriptor != null ? descriptor.getDisplayName() : "";
    }
}

